package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
* 商品可见规则表
* @TableName bcx_product_rules
*/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_product_rules")
@ApiModel(value="BcxProductRules对象", description="商品可见规则表")
public class BcxProductRules implements Serializable {
    private static final long serialVersionUID=1235346234L;

    @TableId(value = "id", type = IdType.AUTO)
    @ApiModelProperty("商品可见规则表id")
    private Integer id;

    @ApiModelProperty("外部唯一ID")
    private String referenceid;

    @ApiModelProperty("商品ID")
    private Integer productId;

    @ApiModelProperty("规则类型 0: none全部可见 1: organization 指定企业 2: region 指定区域 ")
    private Integer matchType;

    @ApiModelProperty("企业Id 或 企业指定区域的编码")
    private String matchValue;

    @ApiModelProperty("指定行业类型")
    private String industryCode;

    @ApiModelProperty("指定机构类型")
    private String institutionalCode;
}
