package com.zbkj.common.enums;

import com.zbkj.common.utils.CrmebUtil;

/**
 * <b> 商品类型(订单号开头规则) </b>
 * @author ZXF
 * @create 2025/09/17 0017 13:38
 * @version
 * @注意事项 </b>
 */
public enum BizEnum {

    PHY("普通商品", 0),
    SIR("虚拟商品", 1),
    SPA("特殊商品", 2),
    INS("保险商品", 3),
    RIS("风评商品", 4);

    private final String name;
    private final Integer value;

    BizEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public Integer getValue() {
        return value;
    }

    //bizType
    public static String beforeRule(Integer value) {
        for (BizEnum biz : BizEnum.values()) {
            if (biz.value.equals(value)) {
                return biz.toString();
            }
        }
        return "PT";
    }

    //子订单数
    public static String lastRule(Integer value) {
        return "S"+(value<10?"0":"")+value;
    }

    //生成订单号 没前缀加前缀
    public static String buildNoPrefix(String orderNo, Integer bizType) {
        boolean isPrefix = false;
        for (BizEnum biz : BizEnum.values()) {
            if (orderNo.startsWith(biz.toString())) {
                isPrefix = true;
                break;
            }
        }
        if(!isPrefix){
            orderNo = CrmebUtil.getOrderNo(beforeRule(bizType));
        }
        return orderNo;
    }
}
