/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.constants.ClosingConstant;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.closing.MerchantClosingRecord;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.ClosingAuditRequest;
import com.zbkj.common.request.ClosingProofRequest;
import com.zbkj.common.request.ClosingRemarkRequest;
import com.zbkj.common.request.MerchantClosingSearchRequest;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.response.MerchantClosingPlatformPageResponse;
import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.common.vo.DateLimitUtilVo;
import com.zbkj.service.dao.MerchantClosingRecordDao;
import com.zbkj.service.service.MerchantClosingRecordService;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.SystemConfigService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class MerchantClosingRecordServiceImpl
extends ServiceImpl<MerchantClosingRecordDao, MerchantClosingRecord>
implements MerchantClosingRecordService {
    @Resource
    private MerchantClosingRecordDao dao;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private SystemConfigService systemConfigService;
    @Autowired
    private TransactionTemplate transactionTemplate;
    @Autowired
    private SystemAttachmentService systemAttachmentService;

    @Override
    public PageInfo<MerchantClosingPlatformPageResponse> getMerchantClosingPageListByPlatform(MerchantClosingSearchRequest request, PageParamRequest pageParamRequest) {
        HashMap map = CollUtil.newHashMap();
        if (ObjectUtil.isNotNull((Object)request.getMerId())) {
            map.put("merId", request.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getClosingNo())) {
            map.put("closingNo", URLUtil.decode((String)request.getClosingNo()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getClosingType())) {
            map.put("closingType", request.getClosingType());
        }
        if (ObjectUtil.isNotNull((Object)request.getAuditStatus())) {
            map.put("auditStatus", request.getAuditStatus());
        }
        if (ObjectUtil.isNotNull((Object)request.getAccountStatus())) {
            map.put("accountStatus", request.getAccountStatus());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            map.put("startTime", dateLimit.getStartTime());
            map.put("endTime", dateLimit.getEndTime());
        }
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List<MerchantClosingPlatformPageResponse> list = this.dao.getMerchantClosingPageListByPlatform(map);
        return CommonPage.copyPageInfo((Page)page, list);
    }

    @Override
    public MerchantClosingRecord getByClosingNo(String closingNo) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        lqw.eq(MerchantClosingRecord::getClosingNo, (Object)closingNo);
        lqw.last("limit 1");
        MerchantClosingRecord merchantClosingRecord = (MerchantClosingRecord)this.dao.selectOne((Wrapper)lqw);
        if (ObjectUtil.isNull((Object)merchantClosingRecord)) {
            throw new CrmebException("\u5546\u6237\u7ed3\u7b97\u5355\u4e0d\u5b58\u5728");
        }
        return merchantClosingRecord;
    }

    @Override
    public Boolean userClosingAudit(ClosingAuditRequest request) {
        MerchantClosingRecord merchantClosing = this.getByClosingNo(request.getClosingNo());
        if (!merchantClosing.getAuditStatus().equals(ClosingConstant.CLOSING_AUDIT_STATUS_AUDIT)) {
            throw new CrmebException("\u63d0\u73b0\u7533\u8bf7\u5df2\u7ecf\u5904\u7406");
        }
        if (request.getAuditStatus().equals(ClosingConstant.CLOSING_AUDIT_STATUS_SUCCESS)) {
            Merchant merchant = this.merchantService.getByIdException(merchantClosing.getMerId());
            String guaranteedAmount = this.systemConfigService.getValueByKey("guaranteed_amount");
            if (new BigDecimal(guaranteedAmount).compareTo(merchant.getBalance().subtract(merchantClosing.getAmount())) > 0) {
                throw new CrmebException("\u5546\u6237\u53ef\u63d0\u73b0\u4f59\u989d\u4e0d\u8db3\uff0c\u5ba1\u6838\u65e0\u6cd5\u6210\u529f");
            }
        }
        SystemAdmin admin = SecurityUtil.getLoginUserVo().getUser();
        merchantClosing.setAuditStatus(request.getAuditStatus());
        merchantClosing.setAuditId(admin.getId());
        merchantClosing.setAuditTime((Date)DateUtil.date());
        if (StrUtil.isNotEmpty((CharSequence)request.getRefusalReason())) {
            merchantClosing.setRefusalReason(request.getRefusalReason());
        }
        return (Boolean)this.transactionTemplate.execute(e -> {
            Boolean result;
            this.updateById(merchantClosing);
            if (request.getAuditStatus().equals(ClosingConstant.CLOSING_AUDIT_STATUS_SUCCESS) && !(result = this.merchantService.operationBalance(merchantClosing.getMerId(), merchantClosing.getAmount(), "sub")).booleanValue()) {
                e.setRollbackOnly();
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
    }

    @Override
    public Boolean proof(ClosingProofRequest request) {
        MerchantClosingRecord merchantClosing = this.getByClosingNo(request.getClosingNo());
        if (!merchantClosing.getAuditStatus().equals(ClosingConstant.CLOSING_AUDIT_STATUS_SUCCESS)) {
            throw new CrmebException("\u7ed3\u7b97\u5355\u5ba1\u6838\u72b6\u6001\u5f02\u5e38!");
        }
        merchantClosing.setClosingProof(this.systemAttachmentService.clearPrefix(request.getClosingProof()));
        merchantClosing.setAccountStatus(ClosingConstant.CLOSING_ACCOUNT_STATUS_SUCCESS);
        merchantClosing.setClosingTime((Date)DateUtil.date());
        return this.updateById(merchantClosing);
    }

    @Override
    public Boolean remark(ClosingRemarkRequest request) {
        MerchantClosingRecord merchantClosing = this.getByClosingNo(request.getClosingNo());
        merchantClosing.setPlatformMark(request.getRemark());
        return this.updateById(merchantClosing);
    }

    @Override
    public PageInfo<MerchantClosingRecord> getMerchantClosingPageListByMerchant(MerchantClosingSearchRequest request, PageParamRequest pageParamRequest) {
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotNull((Object)request.getMerId())) {
            lqw.eq(MerchantClosingRecord::getMerId, (Object)request.getMerId());
        }
        if (StrUtil.isNotBlank((CharSequence)request.getClosingNo())) {
            lqw.eq(MerchantClosingRecord::getClosingNo, (Object)URLUtil.decode((String)request.getClosingNo()));
        }
        if (StrUtil.isNotBlank((CharSequence)request.getClosingType())) {
            lqw.eq(MerchantClosingRecord::getClosingType, (Object)request.getClosingType());
        }
        if (ObjectUtil.isNotNull((Object)request.getAuditStatus())) {
            lqw.eq(MerchantClosingRecord::getAuditStatus, (Object)request.getAuditStatus());
        }
        if (ObjectUtil.isNotNull((Object)request.getAccountStatus())) {
            lqw.eq(MerchantClosingRecord::getAccountStatus, (Object)request.getAccountStatus());
        }
        if (StrUtil.isNotEmpty((CharSequence)request.getDateLimit())) {
            DateLimitUtilVo dateLimit = CrmebDateUtil.getDateLimit((String)request.getDateLimit());
            lqw.between(MerchantClosingRecord::getCreateTime, (Object)dateLimit.getStartTime(), (Object)dateLimit.getEndTime());
        }
        lqw.orderByDesc(MerchantClosingRecord::getId);
        return CommonPage.copyPageInfo((Page)page, (List)this.dao.selectList((Wrapper)lqw));
    }

    @Override
    public List<MerchantClosingRecord> findByDate(Integer merId, String date) {
        LambdaQueryWrapper lqw = Wrappers.lambdaQuery();
        if (merId > 0) {
            lqw.eq(MerchantClosingRecord::getMerId, (Object)merId);
        }
        lqw.eq(MerchantClosingRecord::getAuditStatus, (Object)ClosingConstant.CLOSING_AUDIT_STATUS_SUCCESS);
        lqw.eq(MerchantClosingRecord::getAccountStatus, (Object)ClosingConstant.CLOSING_ACCOUNT_STATUS_SUCCESS);
        lqw.apply("date_format(update_time, '%Y-%m-%d') = {0}", new Object[]{date});
        return this.dao.selectList((Wrapper)lqw);
    }
}

