package com.zbkj.common.request.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 用户企业认证表Request对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxUserOrgAuthRequest对象", description = "用户企业认证Request对象")
public class BcxUserOrgAuthRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "用户企业认证表id")
    private Integer id;

    @ApiModelProperty(value = "用户id")
    private Integer uid;

    @ApiModelProperty(value = "名称", required = true)
    @NotNull
    private String name;

    @ApiModelProperty(value = "身份证号", required = true)
    @NotNull
    private String idCardNo;

    @ApiModelProperty(value = "手机号", required = true)
    @NotNull
    private String phone;

    @ApiModelProperty(value = "验证码", required = true)
    private String authCode;

    @ApiModelProperty(value = "企业名称", required = true)
    @NotNull
    private String orgName;

    @ApiModelProperty(value = "法人", required = true)
    @NotNull
    private String legalPerson;

    @ApiModelProperty(value = "统一社会信用代码", required = true)
    @NotNull
    private String creditCode;

    @ApiModelProperty(value = "注册地", required = true)
    @NotNull
    private String regAddress;

    @ApiModelProperty(value = "详细地址", required = true)
    @NotNull
    private String address;
}
