package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;

/**
 * 订单设备编号
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_order_device_no")
@ApiModel(value = "BcxOrderDeviceNo对象", description = "订单设备编号")
public class BcxOrderDeviceNo implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "订单设备编号id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "设备编号")
    private String deviceNo;

    @ApiModelProperty(value = "商品id")
    private Integer productId;

    @ApiModelProperty(value = "skuId")
    private Integer skuId;

    @ApiModelProperty(value = "买家标识")
    private String account;

    @ApiModelProperty(value = "业务类型子分类：1-对讲机、2-执法记录仪、0-其他")
    private Integer bizSubType;

    @ApiModelProperty(value = "设备型号，对讲机和执法记录仪 这个字段必填")
    private String deviceModel;
}
