package com.zbkj.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

/**
 * <b> 商户转账 </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:21
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="HuifuWalletTransferDto", description="商户转账")
public class HuifuWalletTransferDto implements Serializable {

    @ApiModelProperty(value = "账户状态")
    private String accountStatus;

    @ApiModelProperty(value = "出账方")
    private String outId;

    @ApiModelProperty(value = "入账方")
    private String inId;
    @ApiModelProperty(value = "交易流水号")
    private String reqSeqId;
    @ApiModelProperty(value = "汇付全局流水号")
    private String hfqSeqId;

    @ApiModelProperty(value = "业务交易流水号")
    private String businessPartnerSeq;
    @ApiModelProperty(value = "业务编码")
    private String businessCode;

    @ApiModelProperty(value = "订单金额")
    private String amount;

    @ApiModelProperty(value = "是否需要验证码")
    private String needActiveCode;

    @ApiModelProperty(value = "验证码")
    private String activeCode;

    @ApiModelProperty(value = "手机号")
    private String contactPhone;

    @ApiModelProperty(value = "备注")
    private String comment;

    @ApiModelProperty(value = "划账金额")
    private String lastschriftAmount;

    @ApiModelProperty(value = "批次号")
    private String batchNo;

    @ApiModelProperty(value = "批次名称")
    private String batchName;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "商品名称")
    private String goodsName;
    @ApiModelProperty(value = "商品数量")
    private String goodsNumber;
    @ApiModelProperty(value = "商品单位")
    private String goodsUnit;
    @ApiModelProperty(value = "交易类型：04冻结，05解冻")
    private String tradeType;
    @ApiModelProperty(value = "销售分账优先级 0-平台 1-商户")
    private Integer sellFeePriority;
    @ApiModelProperty(value = "平台分账金额")
    private String platAmount;
    @ApiModelProperty(value = "交易通道")
    private String payChannel;
}
