/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.exception.weixin;

import com.zbkj.common.exception.weixin.CRMEBWxCpErrorMsgEnum;
import com.zbkj.common.exception.weixin.CRMEBWxMaErrorMsgEnum;
import com.zbkj.common.exception.weixin.CRMEBWxMpErrorMsgEnum;
import com.zbkj.common.exception.weixin.CRMEBWxOpenErrorMsgEnum;
import java.io.Serializable;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;

public class CRMEBWxError
implements Serializable {
    private static final long serialVersionUID = 7869786563361406291L;
    private int errcode;
    private String errmsg;
    private String errmsgen;
    private String json;

    public CRMEBWxError(int errorCode, String errorMsg) {
        this.errcode = errorCode;
        this.errmsg = errorMsg;
    }

    public static CRMEBWxError fromJson(String json) {
        return CRMEBWxError.fromJson(json, null);
    }

    public static CRMEBWxError fromJson(String json, WxType type) {
        CRMEBWxError wxError = (CRMEBWxError)WxGsonBuilder.create().fromJson(json, CRMEBWxError.class);
        if (wxError.getErrcode() == 0 || type == null) {
            return wxError;
        }
        if (StringUtils.isNotEmpty((CharSequence)wxError.getErrmsg())) {
            wxError.setErrmsgen(wxError.getErrmsg());
        }
        switch (type) {
            case MP: {
                String msg = CRMEBWxMpErrorMsgEnum.findMsgByCode(wxError.getErrcode());
                if (msg == null) break;
                wxError.setErrmsg(msg);
                break;
            }
            case CP: {
                String msg = CRMEBWxCpErrorMsgEnum.findMsgByCode(wxError.getErrcode());
                if (msg == null) break;
                wxError.setErrmsg(msg);
                break;
            }
            case MiniApp: {
                String msg = CRMEBWxMaErrorMsgEnum.findMsgByCode(wxError.getErrcode());
                if (msg == null) break;
                wxError.setErrmsg(msg);
                break;
            }
            case Open: {
                String msg = CRMEBWxOpenErrorMsgEnum.findMsgByCode(wxError.getErrcode());
                if (msg == null) break;
                wxError.setErrmsg(msg);
                break;
            }
            default: {
                return wxError;
            }
        }
        return wxError;
    }

    public String toString() {
        if (this.json == null) {
            return "\u9519\u8bef\u4ee3\u7801\uff1a" + this.errcode + ", \u9519\u8bef\u4fe1\u606f\uff1a" + this.errmsg;
        }
        return "\u9519\u8bef\u4ee3\u7801\uff1a" + this.errcode + ", \u9519\u8bef\u4fe1\u606f\uff1a" + this.errmsg + "\uff0c\u5fae\u4fe1\u539f\u59cb\u62a5\u6587\uff1a" + this.json;
    }

    public static CRMEBWxErrorBuilder builder() {
        return new CRMEBWxErrorBuilder();
    }

    public int getErrcode() {
        return this.errcode;
    }

    public String getErrmsg() {
        return this.errmsg;
    }

    public String getErrmsgen() {
        return this.errmsgen;
    }

    public String getJson() {
        return this.json;
    }

    public void setErrcode(int errcode) {
        this.errcode = errcode;
    }

    public void setErrmsg(String errmsg) {
        this.errmsg = errmsg;
    }

    public void setErrmsgen(String errmsgen) {
        this.errmsgen = errmsgen;
    }

    public void setJson(String json) {
        this.json = json;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CRMEBWxError)) {
            return false;
        }
        CRMEBWxError other = (CRMEBWxError)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getErrcode() != other.getErrcode()) {
            return false;
        }
        String this$errmsg = this.getErrmsg();
        String other$errmsg = other.getErrmsg();
        if (this$errmsg == null ? other$errmsg != null : !this$errmsg.equals(other$errmsg)) {
            return false;
        }
        String this$errmsgen = this.getErrmsgen();
        String other$errmsgen = other.getErrmsgen();
        if (this$errmsgen == null ? other$errmsgen != null : !this$errmsgen.equals(other$errmsgen)) {
            return false;
        }
        String this$json = this.getJson();
        String other$json = other.getJson();
        return !(this$json == null ? other$json != null : !this$json.equals(other$json));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CRMEBWxError;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getErrcode();
        String $errmsg = this.getErrmsg();
        result = result * 59 + ($errmsg == null ? 43 : $errmsg.hashCode());
        String $errmsgen = this.getErrmsgen();
        result = result * 59 + ($errmsgen == null ? 43 : $errmsgen.hashCode());
        String $json = this.getJson();
        result = result * 59 + ($json == null ? 43 : $json.hashCode());
        return result;
    }

    public CRMEBWxError() {
    }

    public CRMEBWxError(int errcode, String errmsg, String errmsgen, String json) {
        this.errcode = errcode;
        this.errmsg = errmsg;
        this.errmsgen = errmsgen;
        this.json = json;
    }

    public static class CRMEBWxErrorBuilder {
        private int errcode;
        private String errmsg;
        private String errmsgen;
        private String json;

        CRMEBWxErrorBuilder() {
        }

        public CRMEBWxErrorBuilder errcode(int errcode) {
            this.errcode = errcode;
            return this;
        }

        public CRMEBWxErrorBuilder errmsg(String errmsg) {
            this.errmsg = errmsg;
            return this;
        }

        public CRMEBWxErrorBuilder errmsgen(String errmsgen) {
            this.errmsgen = errmsgen;
            return this;
        }

        public CRMEBWxErrorBuilder json(String json) {
            this.json = json;
            return this;
        }

        public CRMEBWxError build() {
            return new CRMEBWxError(this.errcode, this.errmsg, this.errmsgen, this.json);
        }

        public String toString() {
            return "CRMEBWxError.CRMEBWxErrorBuilder(errcode=" + this.errcode + ", errmsg=" + this.errmsg + ", errmsgen=" + this.errmsgen + ", json=" + this.json + ")";
        }
    }
}

