package com.zbkj.admin.task.wallet;

import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.common.utils.DateUtils;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.factory.PaymentFactory;
import com.zbkj.service.service.CommonWalletService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

/**
 * 账号明细等定时任务
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
@Component("WalletTradeTask")
public class WalletTradeTask {
    //日志
    private static final Logger logger = LoggerFactory.getLogger(WalletTradeTask.class);

    @Autowired
    private CommonWalletService commonWalletService;

    @Autowired
    private PaymentFactory paymentFactory;

    /**
     * 每天同步一次数据
     */
    public void tradeDetail() {
        // cron : 0 0 */1 * * ?
        logger.info("---WalletTradeTask task------trade Data with fixed rate task: Execution Time - {}", CrmebDateUtil.nowDateTime());
        try {
//            huifuWalletService.huifuWalletAccountTradeDetailSch();
            paymentFactory.getPaymentChannel(PaymentChannel.HUIFU.getService()).payTradeDetailTaskSch();
            paymentFactory.getPaymentChannel(PaymentChannel.WANGSHANG.getService()).payTradeDetailTaskSch();
//            commonWalletService.payTradeDetailTaskSch();
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("WalletTradeTask.trade" + " | msg : " + e.getMessage());
        }
    }

    /**
     * 每天同步一次数据 (为交易详情记录补前一天的交易后时间)
     */
    public void updateBalance() {
        // cron : 0 0 */5 * * ?
        logger.info("---WalletTradeTask updateBalance------trade Data with fixed rate task: Execution Time - {}", CrmebDateUtil.nowDateTime());
        try {
            paymentFactory.getPaymentChannel(PaymentChannel.HUIFU.getService()).updateBalance("","");
            paymentFactory.getPaymentChannel(PaymentChannel.WANGSHANG.getService()).updateBalance("","");
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("WalletTradeTask.updateBalance" + " | msg : " + e.getMessage());
        }
    }

    /**
     * 每天同步一次数据（查询当前时间前2天对账数据）
     */
    public void reconciliationDetail() {
        // cron : 0 0 */2 * * ?
        logger.info("---WalletTradeTask task------reconciliation Data with fixed rate task: Execution Time - {}", CrmebDateUtil.nowDateTime());
        try {
            commonWalletService.createHuifuWalletReconciliation();
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("WalletTradeTask.reconciliation" + " | msg : " + e.getMessage());
        }
    }

    /**
     * 对账数据补偿（补偿30天前的对账数据）
     */
    public void reconciliationCompensate() {
        // cron : 0 0 */2 * * ?
        logger.info("---WalletTradeTask task------reconciliationCompensate Data with fixed rate task: Execution Time - {}", CrmebDateUtil.nowDateTime());
        try {
            String date = DateUtils.formatDate(DateUtils.addDays(new Date(),-30),"yyyyMMdd");
            commonWalletService.reconciliationReplay(date);
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("WalletTradeTask.reconciliationCompensate" + " | msg : " + e.getMessage());
        }
    }

    /**
     * 1小时查一次，每次查2天
     */
    public void translogDetail() {
        // cron : 0 0 1 * * ?
        logger.info("---WalletTradeTask task------translog Data with fixed rate task: Execution Time - {}", CrmebDateUtil.nowDateTime());
        try {
            paymentFactory.getPaymentChannel(PaymentChannel.HUIFU.getService()).huifuWalletAccountTranslogTask("","");
            paymentFactory.getPaymentChannel(PaymentChannel.WANGSHANG.getService()).huifuWalletAccountTranslogTask("","");
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("WalletTradeTask.translog" + " | msg : " + e.getMessage());
        }
    }
}
