package com.zbkj.admin.task.wallet;

import com.zbkj.common.utils.CrmebDateUtil;
import com.zbkj.service.service.TaskResidualService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 账号明细等定时任务
 * +----------------------------------------------------------------------
 * | CRMEB [ CRMEB赋能开发者，助力企业发展 ]
 * +----------------------------------------------------------------------
 * | Copyright (c) 2016~2023 https://www.crmeb.com All rights reserved.
 * +----------------------------------------------------------------------
 * | Licensed CRMEB并不是自由软件，未经许可不能去掉CRMEB相关版权
 * +----------------------------------------------------------------------
 * | Author: CRMEB Team <admin@crmeb.com>
 * +----------------------------------------------------------------------
 */
@Component("ResidualTask")
public class ResidualTask {
    //日志
    private static final Logger logger = LoggerFactory.getLogger(ResidualTask.class);

    @Autowired
    TaskResidualService taskResidualService;

    /**
     * 每天同步一次数据
     */
    public void residualDetail() {
        // cron : 0 0 */1 * * ?
        logger.info("---ResidualTask task------trade Data with fixed rate task: Execution Time - {}", CrmebDateUtil.nowDateTime());
        try {
            taskResidualService.disposeTaskResidualList("0");
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("WalletTradeTask.trade" + " | msg : " + e.getMessage());
        }
    }

}
