package com.bcxin.ins.web.interceptor;

import com.alibaba.fastjson.JSON;
import com.bcxin.ins.dto.ResultDto;
import com.bcxin.ins.vo.ConstProp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Map;

/**
 * 上传文件类型拦截器
 */
public class FileTypeInterceptor implements HandlerInterceptor {

	protected Logger logger = LoggerFactory.getLogger(getClass());


	@Override
	public boolean preHandle(HttpServletRequest request, HttpServletResponse response,
                             Object handler) throws Exception {
		boolean flag= true;
		// 判断是否为文件上传请求
		if (request instanceof MultipartHttpServletRequest) {
			MultipartHttpServletRequest multipartRequest =
					(MultipartHttpServletRequest) request;
			Map<String, MultipartFile> files =
					multipartRequest.getFileMap();
			Iterator<String> iterator = files.keySet().iterator();
			//对多部件请求资源进行遍历
			while (iterator.hasNext()) {
				String formKey = (String) iterator.next();
				MultipartFile multipartFile =
						multipartRequest.getFile(formKey);
				String filename=multipartFile.getOriginalFilename();
				//判断是否为限制文件类型
				if (!checkFile(filename)) {
					logger.error("不支持的文件类型:"+filename);
					//限制文件类型，请求转发到原始请求页面，并携带错误提示信息
					ResultDto rDto = new ResultDto("不支持的文件类型！", ConstProp.CODE_FAILURE,ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR, ConstProp.BLANK_CHAR);
					PrintWriter out = response.getWriter();
					out.println(JSON.toJSONString(rDto));
					out.flush();
					out.close();
					flag= false;
				}
			}
		}
		return flag;
	}

	/**
	 * 判断是否为允许的上传文件类型,true表示允许
	 */
	private boolean checkFile(String fileName) {
		//设置允许上传文件类型
		String suffixList = "jpg,gif,png,ico,bmp,jpeg,doc,xls,zip,pdf,xlsx,docx,txt,rar,ppt";
		// 获取文件后缀
		String suffix = fileName.substring(fileName.lastIndexOf(".")
				+ 1, fileName.length());
		if (suffixList.contains(suffix.trim().toLowerCase())) {
			return true;
		}
		return false;
	}

	@Override
	public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler,
                           ModelAndView modelAndView) throws Exception {
	}

	@Override
	public void afterCompletion(HttpServletRequest request, HttpServletResponse response,
                                Object handler, Exception ex) throws Exception {

	}

}
