/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.extra.template.engine;

import cn.hutool.core.util.ServiceLoaderUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateException;
import cn.hutool.log.StaticLog;

public class TemplateFactory {
    public static TemplateEngine create(TemplateConfig config) {
        TemplateEngine engine = TemplateFactory.doCreate(config);
        StaticLog.debug("Use [{}] Engine As Default.", StrUtil.removeSuffix(engine.getClass().getSimpleName(), "Engine"));
        return engine;
    }

    private static TemplateEngine doCreate(TemplateConfig config) {
        TemplateEngine engine = ServiceLoaderUtil.loadFirstAvailable(TemplateEngine.class);
        if (null != engine) {
            return engine;
        }
        throw new TemplateException("No template found ! Please add one of template jar to your project !");
    }
}

