<!DOCTYPE html>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="renderer" content="webkit">
    <script src="https://cdn.bootcss.com/jquery/3.4.1/jquery.js"></script>
    <!-- 加载 物可视SDK-->
    <script type="text/javascript" src="https://iotviz2.cdn.bcebos.com/bin/prod/sdk/bdiotvizplayer.min.js"></script>
    <%--    引入layui--%>
    <script src="${pageContext.request.contextPath }/layui/layui.all.js"></script>
    <link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath }/layui/css/layui.css"/>
    <style>
        html, body {
            font-size: 12px;
            font-family: "PingFang SC";
            display: block;
            margin: 0;
            width: 100%;
            height: 100%;
        }

        #content {
            width: 100%;
            height: 100%;
        }
    </style>
</head>

<body>
<div id="content"></div>

<script type="text/javascript">
    var params = '${params}';
    var webUrl = '${webUrl}';

    var count = 0;
    layer.load(0, {shade: [0.8,'#fff']});
    var myTimer = setInterval(clock, 1000);
    function clock() {
        if (count >= 10) {
            layer.closeAll();
            clearInterval(myTimer);
        }
    }

    const bdIotVizPlayer = window.BDIotVizPlayer;
    const container = document.getElementById('content');
    const myDashboard = bdIotVizPlayer({
        containerElement: container,
        dashboardId: '6045796c78dc70000e4edc4e',
        fillMode: 'none', // <-- Optional, Possible value: 'none', 'contain', 'cover', 'responsive'
        token: {
            type: 'embedded', // <-- Must be 'embedded'
            value: '80f6785bd451781cc5aafb89177d4be1' // <-- Access Token for current dashboard
        },
        customizeLogo: { // <-- Customize Logo Info
            enable: true,
            sign: '3696c299661f3b46f66c92f2b64acec4',
            loadingImg: 'https://iotviz2-user.gz.bcebos.com/prod/f2822ecdf2584351ae4b2f1a5f684f0f/images/公安.png?etag=0916bb12613222063192ec62ffb0eb97',
            loadingMsg: ''
        }
    });

    myDashboard.getDashboardConfig().then(function (config) {
        let dataTables = config.dataTables;
        // 寻找并赋值
        let biData1;
        let biData2;
        let biData3;
        let biData4;
        let biData6;
        let biData7;
        let biData8;
        let biData9;
        let biData10;
        let biData11;
        let biData12;
        let biData13;
        let biData14;
        let biData15;
        let biData16;

        dataTables.forEach(data => {
            if (data.name === '公司保安人员数') {
                biData1 = data;
            }
            if (data.name === '资格证获取比例') {
                biData2 = data;
            }
            if (data.name === '资格证获取人数') {
                biData3 = data;
            }
            if (data.name === '保安员投保比例') {
                biData4 = data;
            }
            if (data.name === '近七日保安员入离职情况') {
                biData6 = data;
            }
            if (data.name === '问题人员类型占比') {
                biData7 = data;
            }
            if (data.name === '各类型驻勤点数') {
                biData8 = data;
            }
            if (data.name === '五级保安员数') {
                biData9 = data;
            }
            if (data.name === '四级保安员数') {
                biData10 = data;
            }
            if (data.name === '三级保安员数') {
                biData11 = data;
            }
            if (data.name === '二级保安师数') {
                biData12 = data;
            }
            if (data.name === '一级保安师数') {
                biData13 = data;
            }
            if (data.name === '保安员实名认证情况') {
                biData14 = data;
            }
            if (data.name === '驻勤点总数') {
                biData15 = data;
            }
            if (data.name === '保安公司名称') {
                biData16 = data;
            }
        });

        getBiData1().then(data => {
            biData1.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData1.id, biData1.config);
        }).catch(err => {
            count++;
        });;
        getBiData2().then(data => {
            biData2.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData2.id, biData2.config);
        }).catch(err => {
            count++;
        });;
        getBiData3().then(data => {
            biData3.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData3.id, biData3.config);
        }).catch(err => {
            count++;
        });
        getBiData4().then(data => {
            biData4.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData4.id, biData4.config);
        }).catch(err => {
            count++;
        });
        getBiData6().then(data => {
            biData6.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData6.id, biData6.config);
        }).catch(err => {
            count++;
        });
        getBiData7().then(data => {
            biData7.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData7.id, biData7.config);
        }).catch(err => {
            count++;
        });
        getBiData8().then(data => {
            biData8.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData8.id, biData8.config);
        }).catch(err => {
            count++;
        });
        getBiData9().then(data => {
            biData9.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData9.id, biData9.config);
        }).catch(err => {
            count++;
        });
        getBiData10().then(data => {
            biData10.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData10.id, biData10.config);
        }).catch(err => {
            count++;
        });
        getBiData11().then(data => {
            biData11.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData11.id, biData11.config);
        }).catch(err => {
            count++;
        });
        getBiData12().then(data => {
            biData12.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData12.id, biData12.config);
        }).catch(err => {
            count++;
        });
        getBiData13().then(data => {
            biData13.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData13.id, biData13.config);
        }).catch(err => {
            count++;
        });
        getBiData14().then(data => {
            biData14.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData14.id, biData14.config);
        }).catch(err => {
            count++;
        });
        getBiData15().then(data => {
            biData15.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData15.id, biData15.config);
        }).catch(err => {
            count++;
        });
        getBiData16().then(data => {
            biData16.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData16.id, biData16.config);
        }).catch(err => {
            count++;
        });
    });

    function getBiData1() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "公司保安员人数", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData2() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "资格证获取比例", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData3() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "资格证获取人数", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData4() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安员投保比例", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData6() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "近七日保安员入离职情况", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData7() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "问题人员类型占比", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData8() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "各类型驻勤点数", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData9() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "五级保安员", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData10() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "四级保安员", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData11() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "三级保安员", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData12() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "二级保安师", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData13() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "一级保安师", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData14() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安员实名认证情况", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData15() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "驻勤点总数", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData16() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安公司名称", "platform": "v5_qy_bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

</script>
</body>
</html>