<!DOCTYPE html>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="renderer" content="webkit">
    <script src="https://cdn.bootcss.com/jquery/3.4.1/jquery.js"></script>
    <!-- 加载 物可视SDK-->
    <script type="text/javascript" src="https://iotviz2.cdn.bcebos.com/bin/prod/sdk/bdiotvizplayer.min.js"></script>
    <%--    引入layui--%>
    <script src="${pageContext.request.contextPath }/layui/layui.all.js"></script>
    <link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath }/layui/css/layui.css"/>
    <style>
        html, body {
            font-size: 12px;
            font-family: "PingFang SC";
            display: block;
            margin: 0;
            width: 100%;
            height: 100%;
        }

        #content {
            width: 100%;
            height: 100%;
        }
    </style>
</head>

<body>
<div id="content"></div>

<script type="text/javascript">
    var params = '${params}';
    var webUrl = '${webUrl}';
    var count = 0;
    var loadIndex = layer.load(0, {shade: [0.9, '#808080']});
    const bdIotVizPlayer = window.BDIotVizPlayer;
    const container = document.getElementById('content');
    const myDashboard = bdIotVizPlayer({
        containerElement: container,
        dashboardId: '5ea12270f7e4df1d8707a3b8',
        fillMode: 'none', // <-- Optional, Possible value: 'none', 'contain', 'cover', 'responsive'
        token: {
            type: 'embedded', // <-- Must be 'embedded'
            value: 'dbe0f9ab933d316bcc3b54880fcbb101' // <-- Access Token for current dashboard
        },
        customizeLogo: { // <-- Customize Logo Info
            enable: false,
            sign: '',
            loadingImg: '',
            loadingMsg: ''
        }
    });
    myDashboard.getDashboardConfig().then(function (config) {
        let dataTables = config.dataTables;
        // 寻找并赋值
        let activityData;
        let temperatureData;
        dataTables.forEach(data => {
            if (data.name === '活动态势大屏') {
                activityData = data;
            }
            if (data.name === '活动场次') {
                temperatureData = data;
            }
        });

        getActivityData().then(data => {
            console.log(data);
            activityData.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(activityData.id, activityData.config);
        }).catch(err => {
            count++;
        });
        getTemperatureData().then(data => {
            temperatureData.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(temperatureData.id, temperatureData.config);
        }).catch(err => {
            count++;
        });
    });
    // 'myDashboard' exposes the API to the dashboard loaded
    // refer to API doc for complete API description

    var myTimer=setInterval(clock,1000);
    function clock() {
        if(count>=2){
            layer.close(loadIndex);
            clearInterval(myTimer);
        }
    }

    function getActivityData() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "活动态势大屏", "platform": "psssp"},
                async: false,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getTemperatureData() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "活动场次", "platform": "psssp"},
                async: false,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }


</script>
</body>
</html>