<!DOCTYPE html>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="renderer" content="webkit">
    <script src="https://cdn.bootcss.com/jquery/3.4.1/jquery.js"></script>
    <!-- 加载 物可视SDK-->
    <script type="text/javascript" src="https://iotviz2.cdn.bcebos.com/bin/prod/sdk/bdiotvizplayer.min.js"></script>
    <%--    引入layui--%>
    <script src="${pageContext.request.contextPath }/layui/layui.all.js"></script>
    <link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath }/layui/css/layui.css"/>
    <style>
        html, body {
            font-size: 12px;
            font-family: "PingFang SC";
            display: block;
            margin: 0;
            width: 100%;
            height: 100%;
        }

        #content {
            width: 100%;
            height: 100%;
        }
    </style>
</head>

<body>
<div id="content"></div>

<script type="text/javascript">
    var params = '${params}';
    var webUrl = '${webUrl}';

    var count = 0;
    layer.load(0, {shade: [0.8,'#fff']});
    var myTimer = setInterval(clock, 1000);
    function clock() {
        if (count >= 8) {
            layer.closeAll();
            clearInterval(myTimer);
        }
    }

    const bdIotVizPlayer = window.BDIotVizPlayer;
    const container = document.getElementById('content');
    const myDashboard = bdIotVizPlayer({
        containerElement: container,
        dashboardId: '5ec487dcd936695f2c3df536',
        fillMode: 'fill', // <-- Optional, Possible value: 'none', 'contain', 'cover', 'responsive'
        token: {
            type: 'embedded', // <-- Must be 'embedded'
            value: '3704027384dff7b13ec17b2d712b5a3e' // <-- Access Token for current dashboard
        },
        customizeLogo: { // <-- Customize Logo Info
            enable: true,
            sign: 'a16c48228977375d50304d30e023d35a',
            loadingImg: '/images/load.png',
            loadingMsg: '',
        }
    });

    myDashboard.getDashboardConfig().then(function (config) {
        let dataTables = config.dataTables;
        // 寻找并赋值
        let biData1;
        let biData2;
        let biData3;
        let biData4;
        let biData5;
        let biData6;
        let biData7;
        let biData8;
        dataTables.forEach(data => {
            if (data.name === '接入态势') {
                biData1 = data;
            }
            if (data.name === '活动类型') {
                biData2 = data;
            }
            if (data.name === '活动时间') {
                biData3 = data;
            }
            if (data.name === '活动态势') {
                biData4 = data;
            }
            if (data.name === '活动比例图') {
                biData5 = data;
            }
            if (data.name === '观众数量统计图') {
                biData6 = data;
            }
            if (data.name === '场馆活动统计图') {
                biData7 = data;
            }
            if (data.name === '地图态势') {
                biData8 = data;
            }
        });

        getBiData1().then(data => {
            biData1.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData1.id, biData1.config);
        }).catch(err => {
            count++;
        });
        getBiData2().then(data => {
            biData2.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData2.id, biData2.config);
        }).catch(err => {
            count++;
        });
        getBiData3().then(data => {
            biData3.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData3.id, biData3.config);
        }).catch(err => {
            count++;
        });
        getBiData4().then(data => {
            biData4.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData4.id, biData4.config);
        }).catch(err => {
            count++;
        });
        getBiData5().then(data => {
            biData5.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData5.id, biData5.config);
        }).catch(err => {
            count++;
        });
        getBiData6().then(data => {
            biData6.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData6.id, biData6.config);
        }).catch(err => {
            count++;
        });
        getBiData7().then(data => {
            biData7.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData7.id, biData7.config);
        }).catch(err => {
            count++;
        });
        getBiData8().then(data => {
            biData8.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData8.id, biData8.config);
        }).catch(err => {
            count++;
        });
    });

    function getBiData1() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "安保态势基本信息", "platform": "pssab"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData2() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "参会人员民族", "platform": "pssab"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData3() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "入场人员趋势", "platform": "pssab"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData4() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "重点人员态势", "platform": "pssab"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData5() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "活动安保态势", "platform": "pssab"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData6() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "活动警力态势", "platform": "pssab"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData7() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "战果态势", "platform": "pssab"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData8() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "车辆态势", "platform": "pssab"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

</script>
</body>
</html>