<!DOCTYPE html>
<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8" %>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c" %>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="renderer" content="webkit">
    <script src="https://cdn.bootcss.com/jquery/3.4.1/jquery.js"></script>
    <!-- 加载 物可视SDK-->
    <script type="text/javascript" src="https://iotviz2.cdn.bcebos.com/bin/prod/sdk/bdiotvizplayer.min.js"></script>
    <%--    引入layui--%>
    <script src="${pageContext.request.contextPath }/layui/layui.all.js"></script>
    <link rel="stylesheet" type="text/css" href="${pageContext.request.contextPath }/layui/css/layui.css"/>
    <style>
        html, body {
            font-size: 12px;
            font-family: "PingFang SC";
            display: block;
            margin: 0;
            width: 100%;
            height: 100%;
        }

        #content {
            width: 100%;
            height: 100%;
        }
    </style>
</head>

<body>
<div id="content"></div>

<script type="text/javascript">
    var params = '${params}';
    var webUrl = '${webUrl}';

    var count = 0;
    layer.load(0, {shade: [0.8,'#fff']});
    var myTimer = setInterval(clock, 1000);
    function clock() {
        if (count >= 17) {
            layer.closeAll();
            clearInterval(myTimer);
        }
    }

    const bdIotVizPlayer = window.BDIotVizPlayer;
    const container = document.getElementById('content');
    const myDashboard = bdIotVizPlayer({
        containerElement: container,
        dashboardId: '5eb26ef171cb9243ef8b5386',
        fillMode: 'fill', // <-- Optional, Possible value: 'none', 'contain', 'cover', 'responsive'
        token: {
            type: 'embedded', // <-- Must be 'embedded'
            value: '5a1120e6b24150e4026324db4db12a6f' // <-- Access Token for current dashboard
        },
        customizeLogo: { // <-- Customize Logo Info
            enable: true,
            sign: '',
            loadingImg: '/images/load.png',
            loadingMsg: '加载中...',
        }
    });
    myDashboard.getDashboardConfig().then(function (config) {
        let dataTables = config.dataTables;
        // 寻找并赋值
        let biData1;
        let biData2;
        let biData3;
        let biData4;
        let biData5;
        let biData6;
        let biData7;
        let biData8;
        let biData10;
        let biData11;
        let biData12;
        let biData13;
        let biData14;
        let biData15;
        let biData16;
        let biData17;
        let biData18;
        dataTables.forEach(data => {
            if (data.name === '入驻系统保安服务公司') {
                biData1 = data;
            }
            if (data.name === '入驻系统培训机构') {
                biData2 = data;
            }
            if (data.name === '入驻系统自招单位') {
                biData3 = data;
            }
            if (data.name === '系统备案驻勤点数量') {
                biData4 = data;
            }
            if (data.name === '系统登记在职保安员') {
                biData5 = data;
            }
            if (data.name === '系统在岗保安员数量') {
                biData6 = data;
            }
            if (data.name === '黑名单人员') {
                biData7 = data;
            }
            if (data.name === '保安服务公司类型') {
                biData8 = data;
            }
            if (data.name === '驻勤点类型分布') {
                biData10 = data;
            }
            if (data.name === '保安服务公司人员规模统计') {
                biData11 = data;
            }
            if (data.name === '各个地区保安情况') {
                biData12 = data;
            }
            if (data.name === '保安服务公司表彰奖励') {
                biData13 = data;
            }
            if (data.name === '保安服务公司违法违规处罚') {
                biData14 = data;
            }
            if (data.name === '保安服务公司投诉信息') {
                biData15 = data;
            }
            if (data.name === '保安员表彰奖励') {
                biData16 = data;
            }
            if (data.name === '保安员违法违规处罚') {
                biData17 = data;
            }
            if (data.name === '保安员投诉信息') {
                biData18 = data;
            }
        });

        getBiData1().then(data => {
            biData1.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData1.id, biData1.config);
        }).catch(err => {
            count++;
        });
        getBiData2().then(data => {
            biData2.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData2.id, biData2.config);
        }).catch(err => {
            count++;
        });
        getBiData3().then(data => {
            biData3.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData3.id, biData3.config);
        }).catch(err => {
            count++;
        });
        getBiData4().then(data => {
            biData4.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData4.id, biData4.config);
        }).catch(err => {
            count++;
        });
        getBiData5().then(data => {
            biData5.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData5.id, biData5.config);
        }).catch(err => {
            count++;
        });
        getBiData6().then(data => {
            biData6.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData6.id, biData6.config);
        }).catch(err => {
            count++;
        });
        getBiData7().then(data => {
            biData7.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData7.id, biData7.config);
        }).catch(err => {
            count++;
        });
        getBiData8().then(data => {
            biData8.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData8.id, biData8.config);
        }).catch(err => {
            count++;
        });
        getBiData10().then(data => {
            biData10.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData10.id, biData10.config);
        }).catch(err => {
            count++;
        });
        getBiData11().then(data => {
            biData11.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData11.id, biData11.config);
        }).catch(err => {
            count++;
        });
        getBiData12().then(data => {
            biData12.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData12.id, biData12.config);
        }).catch(err => {
            count++;
        });
        getBiData13().then(data => {
            biData13.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData13.id, biData13.config);
        }).catch(err => {
            count++;
        });
        getBiData14().then(data => {
            biData14.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData14.id, biData14.config);
        }).catch(err => {
            count++;
        });
        getBiData15().then(data => {
            biData15.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData15.id, biData15.config);
        }).catch(err => {
            count++;
        });
        getBiData16().then(data => {
            biData16.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData16.id, biData16.config);
        }).catch(err => {
            count++;
        });
        getBiData17().then(data => {
            biData17.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData17.id, biData17.config);
        });
        getBiData18().then(data => {
            biData18.config.source = data;
            count++;
            // 更新数据
            return myDashboard.updateDataTableConfig(biData18.id, biData18.config);
        }).catch(err => {
            count++;
        });
    });

    function getBiData1() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "入驻系统保安服务公司", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData2() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "入驻系统培训机构", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData3() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "入驻系统自招单位", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData4() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "系统备案驻勤点数量", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData5() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "系统登记在职保安员", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData6() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "系统在岗保安员数量", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData7() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "黑名单人员", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData8() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安服务公司类型", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }


    function getBiData10() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "驻勤点类型分布", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

    function getBiData11() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安服务公司人员规模统计", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }
    function getBiData12() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "各个地区保安情况", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }
    function getBiData13() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安服务公司表彰奖励", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                    console.log(json.data);
                }
            });
        });
    }
    function getBiData14() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安服务公司违法违规处罚", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }
    function getBiData15() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安服务公司投诉信息", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }
    function getBiData16() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安员表彰奖励", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }
    function getBiData17() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安员违法违规处罚", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }
    function getBiData18() {
        return new Promise((resolve, reject) => {
            $.ajax({
                type: 'POST',
                url: webUrl + '/data',
                data: {"params": params, "dataSourceName": "保安员投诉信息", "platform": "bbd"},
                async: true,
                success: function (json) {
                    resolve(json.data); // response.data 的格式为 [{location: 'xxx', temperature: 0}, ...]
                }
            });
        });
    }

</script>
</body>
</html>