package com.bcxin.bi.startup;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.bcxin.bi.common.dao.entity.BiConfig;
import com.bcxin.bi.common.dao.repository.BiConfigMapper;
import com.bcxin.bi.common.util.ConfigUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;

@Service
@Slf4j
public class MyStartupRunner implements CommandLineRunner {

	@Resource
	private BiConfigMapper biConfigMapper;
	
	@Override
	public void run(String... args) {
		log.info("初始化系统配置...");
		List<BiConfig> configList = biConfigMapper.selectList(new EntityWrapper<BiConfig>());
		for(BiConfig config : configList) {
			ConfigUtil.putValue(config);
			log.info(config.getSysKey()+":"+config.getSysValue());
		}
		log.info("初始化字典配置...");
	}

}
