package com.bcxin.bi.service;

import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.bcxin.bi.common.annotion.DataSource;
import com.bcxin.bi.common.dao.entity.BiView;
import com.bcxin.bi.common.dao.repository.BiDataMapper;
import com.bcxin.bi.common.dao.repository.ViewDataSourceMapper;
import com.bcxin.bi.common.dao.repository.BiViewMapper;
import com.bcxin.bi.common.mutidatesource.DSEnum;
import com.bcxin.bi.common.util.ConfigUtil;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

@Service
public class ViewService {

    @Resource
    private BiDataMapper biDataMapper;

    @Resource
    private BiViewMapper biViewMapper;

    @Resource
    private ViewDataSourceMapper viewDataSourceMapper;

    /**
     * 得到大屏路径，展示大屏
     */
    @DataSource(name = DSEnum.DATA_SOURCE_BI)
    public BiView view(Map<String, String> paramMap ) {
        BiView param = new BiView();
        param.setCode(paramMap.get("viewCode"));
        param.setNature(ConfigUtil.getValue("nature"));
        return biViewMapper.selectOne(param);
    }

    @DataSource(name = DSEnum.DATA_SOURCE_BI)
    public List<BiView> viewList() {
        EntityWrapper<BiView> wrapper = new EntityWrapper<BiView>();
        return biViewMapper.selectList(wrapper);
    }
}
