package com.bcxin.bi.service;

import com.alibaba.druid.util.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.baomidou.mybatisplus.mapper.EntityWrapper;
import com.bcxin.bi.common.annotion.DataSource;
import com.bcxin.bi.common.dao.entity.ViewDataSource;
import com.bcxin.bi.common.dao.repository.BiDataMapper;
import com.bcxin.bi.common.dao.repository.ViewDataSourceMapper;
import com.bcxin.bi.common.mutidatesource.DSEnum;
import com.bcxin.bi.common.util.JwtUtil;
import io.jsonwebtoken.Claims;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 大屏服务类
 */
@Service
public class ViewDataService {

    private static final Pattern PATTERN = Pattern.compile("\\[.*?]");

    @Resource
    private BiDataMapper biDataMapper;

    @Resource
    private ViewDataSourceMapper viewDataSourceMapper;


    @DataSource(name = DSEnum.DATA_SOURCE_BI)
    public ViewDataSource findDataSource(String sourceName,String sourceSign) {
       List<ViewDataSource> list = viewDataSourceMapper.selectList(new EntityWrapper<ViewDataSource>().addFilter("name={0} and platform={1}", sourceName, sourceSign));
       return list.size()>0?list.get(0):null;
    }

    @DataSource(name = DSEnum.DATA_SOURCE_PSSSP)
    public List<LinkedHashMap> data_sp(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_PSSAB)
    public List<LinkedHashMap> data_ab(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_PSSSB)
    public List<LinkedHashMap> data_sb(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_PSS)
    public List<LinkedHashMap> data_pss(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_SAAS)
    public List<LinkedHashMap> data_saas(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_V5_JG_SF)
    public List<LinkedHashMap> data_v5_jg_sf(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        System.out.println("======>ViewDataService======>/findDataSource======>execSql："+execSql);
        String disposeSql = disposeSql(execSql,paramMap);
        System.out.println("======>ViewDataService======>/findDataSource======>disposeSql："+disposeSql);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_V5_QY_BBD)
    public List<LinkedHashMap> data_v5_qy_bbd(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_BKT)
    public List<LinkedHashMap> data_bkt(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_BBD)
    public List<LinkedHashMap> data_bbd(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_V5_JG_SF_NX)
    public List<LinkedHashMap> data_v5_jg_sf_nx(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_V5_JG_SF_BJ)
    public List<LinkedHashMap> data_v5_jg_sf_bj(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }
    @DataSource(name = DSEnum.DATA_SOURCE_V5_QY_BBD_BJ)
    public List<LinkedHashMap> data_v5_qy_bbd_bj(Map<String, String> paramMap, ViewDataSource dataSource) {
        String execSql = dataSource.getExec();
        String disposeSql = disposeSql(execSql,paramMap);
        return biDataMapper.exec(disposeSql);
    }

    private String disposeSql(String sql,Map<String, String> param) {
        String params = param.get("params");
        Claims claims = JwtUtil.parseJWT(params);
        String subject = claims.getSubject();
        Map<String, String> paramMap = JSON.parseObject(subject, new TypeReference<HashMap<String, String>>(){ });
        Matcher matcher = PATTERN.matcher(sql);
        while (matcher.find()) {
            for (String key : paramMap.keySet()) {
                if (StringUtils.isEmpty(paramMap.get(key)) && (matcher.group().contains("{" + key + "}"))) {
                    sql = sql.replace(matcher.group(), "");
                }
            }
        }
        for (String key : paramMap.keySet()) {
            if (sql.contains("{" + key + "}")) {
                sql = sql.replace("{" + key + "}", paramMap.get(key));
            }
        }
        sql = sql.replace("[","");
        sql = sql.replace("]","");
        return sql;
    }

}
