package com.bcxin.bi.controller;

import com.bcxin.bi.common.dao.entity.ViewDataSource;
import com.bcxin.bi.common.mutidatesource.DSEnum;
import com.bcxin.bi.common.util.BcxinWebUtil;
import com.bcxin.bi.common.util.Result;
import com.bcxin.bi.service.ViewDataService;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * 数据处理
 */
@RestController
@CrossOrigin
public class BiDataController {

    @Resource
    private ViewDataService viewDataService;


    @RequestMapping(value = "/data", method = RequestMethod.POST)
    @ResponseBody
    public Result data(HttpServletRequest request) {
        System.out.println("======>BiDataController======>/data======>star!");
        Result result = new Result();
        Map<String, String> paramMap = BcxinWebUtil.getParameterMap(request);
        System.out.println("======>BiDataController======>/data======>paramMap:"+paramMap.toString());
        if (DSEnum.DATA_SOURCE_PSSSP.equalsIgnoreCase(paramMap.get("platform"))) {
            ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
            List<LinkedHashMap> mapList = null;
            try {
                viewDataService.data_sp(paramMap, dataSource);
            } catch (Exception e) {
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_PSSSB.equalsIgnoreCase(paramMap.get("platform"))) {
            ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
            List<LinkedHashMap> mapList = null;
            try {
                viewDataService.data_sb(paramMap, dataSource);
            } catch (Exception e) {
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_PSSAB.equalsIgnoreCase(paramMap.get("platform"))) {
            ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
            List<LinkedHashMap> mapList = null;
            try {
                viewDataService.data_ab(paramMap, dataSource);
            } catch (Exception e) {
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_PSS.equalsIgnoreCase(paramMap.get("platform"))) {
            ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
            List<LinkedHashMap> mapList = null;
            try {
                viewDataService.data_pss(paramMap, dataSource);
            } catch (Exception e) {
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_SAAS.equalsIgnoreCase(paramMap.get("platform"))) {
            ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
            List<LinkedHashMap> mapList = null;
            try {
                viewDataService.data_saas(paramMap, dataSource);
            } catch (Exception e) {
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_V5_JG_SF.equalsIgnoreCase(paramMap.get("platform"))) {
            List<LinkedHashMap> mapList = null;
            try {
                ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
                mapList = viewDataService.data_v5_jg_sf(paramMap, dataSource);
            } catch (Exception e) {
                e.printStackTrace();
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_V5_QY_BBD.equalsIgnoreCase(paramMap.get("platform"))) {
            ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
            List<LinkedHashMap> mapList = null;
            try {
                mapList = viewDataService.data_v5_qy_bbd(paramMap, dataSource);
            } catch (Exception e) {
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_BKT.equalsIgnoreCase(paramMap.get("platform"))) {
            ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
            List<LinkedHashMap> mapList = null;
            try {
                viewDataService.data_bkt(paramMap, dataSource);
            } catch (Exception e) {
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_BBD.equalsIgnoreCase(paramMap.get("platform"))) {
            ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
            List<LinkedHashMap> mapList = null;
            try {
                mapList = viewDataService.data_bbd(paramMap, dataSource);
            } catch (Exception e) {
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_V5_JG_SF_NX.equalsIgnoreCase(paramMap.get("platform"))) {
            List<LinkedHashMap> mapList = null;
            try {
                ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
                mapList = viewDataService.data_v5_jg_sf_nx(paramMap, dataSource);
            } catch (Exception e) {
                e.printStackTrace();
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_V5_JG_SF_BJ.equalsIgnoreCase(paramMap.get("platform"))) {
            List<LinkedHashMap> mapList = null;
            try {
                ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
                mapList = viewDataService.data_v5_jg_sf_bj(paramMap, dataSource);
            } catch (Exception e) {
                e.printStackTrace();
            }
            result.setData(mapList);
            result.setSuccess(true);
        } else if (DSEnum.DATA_SOURCE_V5_QY_BBD_BJ.equalsIgnoreCase(paramMap.get("platform"))) {
            ViewDataSource dataSource = viewDataService.findDataSource(paramMap.get("dataSourceName"),paramMap.get("platform").toUpperCase());
            List<LinkedHashMap> mapList = null;
            try {
                mapList = viewDataService.data_v5_qy_bbd_bj(paramMap, dataSource);
            } catch (Exception e) {
            }
            result.setData(mapList);
            result.setSuccess(true);
        }
        System.out.println("======>BiDataController======>/data======>end!");
        return result;



    }

}
