package com.bcxin.bi.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.baomidou.mybatisplus.plugins.PaginationInterceptor;
import com.bcxin.bi.common.mutidatesource.DSEnum;
import com.bcxin.bi.common.mutidatesource.DynamicDataSource;
import com.bcxin.bi.common.util.SpringContextUtil;
import com.bcxin.bi.config.properties.*;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

import java.sql.SQLException;
import java.util.HashMap;

/**
 * MybatisPlus配置
 */
@Configuration
@EnableTransactionManagement(order = 2)
@MapperScan(basePackages = {"com.bcxin.bi.*"})
public class MybatisPlusConfig {

    @Autowired
    private DruidProperties druidProperties;
    @Autowired
    private PSSSBDataSourceProperties psssbDataSourceProperties;
    @Autowired
    private PSSSPDataSourceProperties pssspDataSourceProperties;
    @Autowired
    private PSSABDataSourceProperties pssabDataSourceProperties;
    @Autowired
    private PSSDataSourceProperties pssDataSourceProperties;
    @Autowired
    private SAASDataSourceProperties saasDataSourceProperties;
    @Autowired
    private V5_JG_SF_DataSourceProperties v5_JG_SF_DataSourceProperties;
    @Autowired
    private V5_QY_BBD_DataSourceProperties v5_QY_BBD_DataSourceProperties;
    @Autowired
    private V5_JG_SF_NX_DataSourceProperties v5_JG_SF_NX_DataSourceProperties;
    @Autowired
    private V5_JG_SF_BJ_DataSourceProperties v5_JG_SF_BJ_DataSourceProperties;
    @Autowired
    private V5_QY_BBD_BJ_DataSourceProperties v5_QY_BBD_BJ_DataSourceProperties;
    @Autowired
    private BKTDataSourceProperties bktDataSourceProperties;
    @Autowired
    private BBDDataSourceProperties bbdDataSourceProperties;

    /**
     * BI数据源
     */
    private DruidDataSource biDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        druidProperties.config(dataSource);
        return dataSource;
    }

    /**
     * PSSSB数据源
     */
    private DruidDataSource psssbDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        //druidProperties.config(dataSource);
        psssbDataSourceProperties.config(dataSource);
        return dataSource;
    }

    /**
     * PSSSP数据源
     */
    private DruidDataSource pssspDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
//        druidProperties.config(dataSource);
        pssspDataSourceProperties.config(dataSource);
        return dataSource;
    }
    /**
     * PSSAB数据源
     */
    private DruidDataSource pssabDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
//        druidProperties.config(dataSource);
        pssabDataSourceProperties.config(dataSource);
        return dataSource;
    }
    /**
     * PSS数据源
     */
    private DruidDataSource pssDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        //druidProperties.config(dataSource);
        pssDataSourceProperties.config(dataSource);
        return dataSource;
    }
    /**
     * bkt数据源
     */
    private DruidDataSource bktDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        //druidProperties.config(dataSource);
        //bktDataSourceProperties.config(dataSource);
        return dataSource;
    }
    /**
     * bbd数据源
     */
    private DruidDataSource bbdDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
//        druidProperties.config(dataSource);
        bbdDataSourceProperties.config(dataSource);
        return dataSource;
    }
    /**
     * saas数据源
     */
    private DruidDataSource saasDataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        //druidProperties.config(dataSource);
        //saasDataSourceProperties.config(dataSource);
        return dataSource;
    }
    /**
     * v5 监管数据源
     */
    private DruidDataSource v5_JG_SF_DataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        v5_JG_SF_DataSourceProperties.config(dataSource);
        return dataSource;
    }
    /**
     * v5 企业数据源
     */
    private DruidDataSource v5_QY_BBD_DataSource() {
        DruidDataSource dataSource = new DruidDataSource();
//        druidProperties.config(dataSource);
        v5_QY_BBD_DataSourceProperties.config(dataSource);
        return dataSource;
    }
    /**
     * v5 监管数据源 宁夏
     */
    private DruidDataSource v5_JG_SF_NX_DataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        v5_JG_SF_NX_DataSourceProperties.config(dataSource);
        return dataSource;
    }
    /**
     * v5 监管数据源 北京
     */
    private DruidDataSource v5_JG_SF_BJ_DataSource() {
        DruidDataSource dataSource = new DruidDataSource();
        v5_JG_SF_BJ_DataSourceProperties.config(dataSource);
        return dataSource;
    }
    /**
     * v5 企业数据源 北京
     */
    private DruidDataSource v5_QY_BBD_BJ_DataSource() {
        DruidDataSource dataSource = new DruidDataSource();
//        druidProperties.config(dataSource);
        v5_QY_BBD_BJ_DataSourceProperties.config(dataSource);
        return dataSource;
    }

    /**
     * 单数据源连接池配置
     */
    @Bean
    @ConditionalOnProperty(prefix = "bcxin", name = "muti-datasource-open", havingValue = "false")
    public DruidDataSource singleDatasource() {
        return psssbDataSource();
    }

    /**
     * 多数据源连接池配置
     */
    @Bean
    @ConditionalOnProperty(prefix = "bcxin", name = "muti-datasource-open", havingValue = "true")
    public DynamicDataSource mutiDataSource() {

        DruidDataSource biDataSource = biDataSource();
        DruidDataSource psssbDataSource = psssbDataSource();
        DruidDataSource pssspDataSource = pssspDataSource();
        DruidDataSource pssabDataSource = pssabDataSource();
        DruidDataSource pssDataSource = pssDataSource();
        //DruidDataSource saasDataSource = saasDataSource();
//        DruidDataSource v5_JG_SF_DataSource = v5_JG_SF_DataSource();
//        DruidDataSource v5_QY_BBD_DataSource = v5_QY_BBD_DataSource();
//        DruidDataSource v5_JG_SF_NX_DataSource = v5_JG_SF_NX_DataSource();
//        DruidDataSource v5_JG_SF_BJ_DataSource = v5_JG_SF_BJ_DataSource();
  //      DruidDataSource v5_QY_BBD_BJ_DataSource = v5_QY_BBD_BJ_DataSource();
        //DruidDataSource bktDataSource = bktDataSource();
//        DruidDataSource bbdDataSource = bbdDataSource();

        try {
            psssbDataSource.init();
            pssspDataSource.init();
            pssabDataSource.init();
            pssDataSource.init();
            //saasDataSource.init();
            //bktDataSource.init();
//            v5_JG_SF_DataSource.init();
//            v5_QY_BBD_DataSource.init();
//            v5_JG_SF_NX_DataSource.init();
//            v5_JG_SF_BJ_DataSource.init();
  //        v5_QY_BBD_BJ_DataSource.init();
            if(!"ningxia".equalsIgnoreCase(SpringContextUtil.getActiveProfile())) {
//                bbdDataSource.init();
            }
        } catch (SQLException sql) {
            sql.printStackTrace();
        }

        DynamicDataSource dynamicDataSource = new DynamicDataSource();
        HashMap<Object, Object> hashMap = new HashMap<>();
        hashMap.put(DSEnum.DATA_SOURCE_BI, biDataSource);
        hashMap.put(DSEnum.DATA_SOURCE_PSSSB, psssbDataSource);
        hashMap.put(DSEnum.DATA_SOURCE_PSSSP, pssspDataSource);
        hashMap.put(DSEnum.DATA_SOURCE_PSSAB, pssabDataSource);
        hashMap.put(DSEnum.DATA_SOURCE_PSS, pssDataSource);
        //hashMap.put(DSEnum.DATA_SOURCE_SAAS, saasDataSource);
//        hashMap.put(DSEnum.DATA_SOURCE_V5_JG_SF, v5_JG_SF_DataSource);
//        hashMap.put(DSEnum.DATA_SOURCE_V5_QY_BBD, v5_QY_BBD_DataSource);
//        hashMap.put(DSEnum.DATA_SOURCE_V5_JG_SF_NX, v5_JG_SF_NX_DataSource);
//        hashMap.put(DSEnum.DATA_SOURCE_V5_JG_SF_BJ, v5_JG_SF_BJ_DataSource);
  //      hashMap.put(DSEnum.DATA_SOURCE_V5_QY_BBD_BJ, v5_QY_BBD_BJ_DataSource);
        //hashMap.put(DSEnum.DATA_SOURCE_BKT, bktDataSource);
//        hashMap.put(DSEnum.DATA_SOURCE_BBD, bbdDataSource);
        dynamicDataSource.setTargetDataSources(hashMap);
        dynamicDataSource.setDefaultTargetDataSource(biDataSource);
        return dynamicDataSource;
    }

    /**
     * mybatis-plus分页插件
     */
    @Bean
    public PaginationInterceptor paginationInterceptor() {
        return new PaginationInterceptor();
    }
}
