package com.bcxin.bi.common.util;


import com.bcxin.bi.common.dao.entity.BiConfig;

import java.util.HashMap;
import java.util.Map;

public class ConfigUtil {

	private static Map<String, String> data = new HashMap<String, String>();
	
	public static String getValue(String key) {
		if (key.equalsIgnoreCase("web_url")) {
			String os = System.getProperty("os.name");
			if (os.toLowerCase().startsWith("win")) {
				return "http://localhost:8080";
			}
			String profile = SpringContextUtil.getActiveProfile();
			return ConfigUtil.getValue(profile + "_web_url");
		}
		return data.get(key);
	}
	
	public static void putValue(BiConfig config) {
		data.put(config.getSysKey(), config.getSysValue());
	}
	
	public static void putValue(String key,String value) {
		data.put(key, value);
	}

	public static Map<String, String> getData() {
		return data;
	}
	
}
