package com.bcxin.bi.common.util;

import com.google.common.collect.Maps;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;

public class BcxinWebUtil {
	

    /**
     * 取得request中所有的参数名
     *
     * @param request
     * @return
     */
    private static List<String> getRequestParamNames(HttpServletRequest request) {

        Enumeration<String> paramNameEnum = request.getParameterNames();
        List<String> result = new ArrayList<String>();

        //先将Enumeration中参数转成LIST
        while (paramNameEnum.hasMoreElements()) {
            result.add(paramNameEnum.nextElement().trim());
        }

        return result;
    }

    /**
     * 取得请求中的所有参数的键值对
     * add by chenmk 2009.12.25
     *
     * @param request
     * @return
     */
    public static Map<String, String> getParameterMap(HttpServletRequest request) {
        List<String> paramNameList = getRequestParamNames(request);

        Map<String, String> result = Maps.newHashMap();

        if (paramNameList == null || paramNameList.size() == 0) {
            return result;
        }

        for(String paramName : paramNameList){
            result.put(paramName, request.getParameter(paramName));
        }

        return result;
    }

}
