package com.bcxin.bi.common.interceptor;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Configuration
public class WebSecurityConfig extends WebMvcConfigurerAdapter {

    @Bean
    public SecurityInterceptor getSecurityInterceptor() {
        return new SecurityInterceptor();
    }

    @Override
    public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")
                .allowedHeaders("*")
                .allowedMethods("*")
                .maxAge(1800)
                .allowedOrigins("*");
    }

    @Override
    public void addInterceptors(InterceptorRegistry registry) {
        InterceptorRegistration addInterceptor = registry.addInterceptor(getSecurityInterceptor());

        // 排除配置
        addInterceptor.excludePathPatterns("/error");
        addInterceptor.excludePathPatterns("/security/login**");
        addInterceptor.excludePathPatterns("/static**");
        addInterceptor.excludePathPatterns("/images**");

        // 拦截配置
        addInterceptor.addPathPatterns("/business/**","/operate/**");
    }

    /**
     * 登录拦截校验
     */
    private class SecurityInterceptor extends HandlerInterceptorAdapter {
        @Override
        public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler)
                throws Exception {
            //HttpSession session = request.getSession();
            //Object logUser = session.getAttribute(GlobalConst.LOGIN_USER);
            //if (logUser != null) {
            //    return true;
            //}
            //// 跳转登录
            ///* 浙江 */
            //if (GlobalConst.ENVI_ZHEJIANG.equals(ConfigUtil.getValue("envi"))) {
            //    String url = "/security/login";
            //    response.sendRedirect(url);
            //    return false;
            //}
            //String url = "/police/security/login";
            //response.sendRedirect(url);
            //return false;
            return true;
        }
    }
}