package com.bcxin.bi.common.dao.entity;

import com.baomidou.mybatisplus.activerecord.Model;
import com.baomidou.mybatisplus.annotations.TableId;
import com.baomidou.mybatisplus.annotations.TableName;
import com.baomidou.mybatisplus.enums.IdType;
import lombok.Data;

import java.io.Serializable;

/**
 * 某一张大屏
 */
@TableName(value = "bi_view")
@Data
public class BiView extends Model<BiView> {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value="oid", type= IdType.AUTO)
    private Long oid;

    /**
     * 大屏唯一编码
     */
    private String code;

    /**
     * 大屏名称
     */
    private String name;

    /**
     * 所属系统
     */
    private String platform;

    /**
     * 大屏对应地址
     */
    private String path;

    /**
     * 内网还是外网
     * 内网：in
     * 外网：out
     */
    private String nature;


    @Override
    protected Serializable pkVal() {
        return this.oid;
    }
}
