package com.bcxin.auth.common.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 全局配置类
 * 
 * @author bcxin
 */
@Component
@ConfigurationProperties(prefix = "bcxin")
public class BMSConfig
{
    /** 项目名称 */
    private static String name;

    /** 版本 */
    private static String version;

    /** 版权年份 */
    private static String copyrightYear;

    /** 实例演示开关 */
    private static boolean demoEnabled;

    /** 上传路径 */
    private static String profile;

    private static String dataSyncProfile;

    /** 获取地址开关 */
    private static boolean addressEnabled;

    public static String getName()
    {
        return name;
    }

    public static String getDataSyncProfile() {
        return dataSyncProfile;
    }

    public void setDataSyncProfile(String dataSyncProfile) {
        BMSConfig.dataSyncProfile = dataSyncProfile;
    }

    public void setName(String name)
    {
        BMSConfig.name = name;
    }

    public static String getVersion()
    {
        return version;
    }

    public void setVersion(String version)
    {
        BMSConfig.version = version;
    }

    public static String getCopyrightYear()
    {
        return copyrightYear;
    }

    public void setCopyrightYear(String copyrightYear)
    {
        BMSConfig.copyrightYear = copyrightYear;
    }

    public static boolean isDemoEnabled()
    {
        return demoEnabled;
    }

    public void setDemoEnabled(boolean demoEnabled)
    {
        BMSConfig.demoEnabled = demoEnabled;
    }

    public static String getProfile()
    {
        return profile;
    }

    public void setProfile(String profile)
    {
        BMSConfig.profile = profile;
    }

    public static boolean isAddressEnabled()
    {
        return addressEnabled;
    }

    public void setAddressEnabled(boolean addressEnabled)
    {
        BMSConfig.addressEnabled = addressEnabled;
    }

    /**
     * 获取头像上传路径
     */
    public static String getAvatarPath()
    {
        return getProfile() + "avatar/";
    }

    /**
     * 获取下载路径
     */
    public static String getDownloadPath()
    {
        return getProfile() + "download/";
    }

    /**
     * 获取上传路径
     */
    public static String getUploadPath()
    {
        return getProfile() + "upload/";
    }

    /**
     * 获取临时目录
     * @return
     */
    public static String getTempPath()
    {
        return getProfile() + "temp/";
    }

    /**
     * 获取对外摆渡目录
     * @return
     */
    public static String getDataSyncToOutPath()
    {
        return getProfile() + "dataSync/toOut/";
    }

    /**
     * 获取对内摆渡目录
     * @return
     */
    public static String getDataSyncToInPath()
    {
        return getProfile() + "dataSync/toIn/";
    }
}
