/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.common.utils.operator;

import com.bcxin.auth.common.utils.operator.Calculator;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FormulaParser {
    private static Pattern pattern = Pattern.compile("\\#\\{(.+?)\\}");

    public static BigDecimal parse(String formula, Map<String, String> formulas, Map<String, BigDecimal> values) {
        if (formulas == null) {
            formulas = Collections.emptyMap();
        }
        if (values == null) {
            values = Collections.emptyMap();
        }
        String expression = FormulaParser.finalExpression(formula, formulas, values);
        return new Calculator().eval(expression);
    }

    public static BigDecimal parse(String formula, Map<String, BigDecimal> values) {
        if (values == null) {
            values = Collections.emptyMap();
        }
        return FormulaParser.parse(formula, Collections.emptyMap(), values);
    }

    public static BigDecimal parse(String formula) {
        return FormulaParser.parse(formula, Collections.emptyMap(), Collections.emptyMap());
    }

    private static String finalExpression(String expression, Map<String, String> formulas, Map<String, BigDecimal> values) {
        Matcher m = pattern.matcher(expression);
        if (!m.find()) {
            return expression;
        }
        m.reset();
        StringBuffer buffer = new StringBuffer();
        while (m.find()) {
            String group = m.group(1);
            if (formulas != null && formulas.containsKey(group)) {
                String formula = formulas.get(group);
                m.appendReplacement(buffer, '(' + formula + ')');
                continue;
            }
            if (values != null && values.containsKey(group)) {
                BigDecimal value = values.get(group);
                m.appendReplacement(buffer, value.toPlainString());
                continue;
            }
            throw new IllegalArgumentException("expression '" + expression + "' has a illegal variable:" + m.group() + ",cause veriable '" + group + "' not being found in formulas or in values.");
        }
        m.appendTail(buffer);
        return FormulaParser.finalExpression(buffer.toString(), formulas, values);
    }

    public static void main(String[] args) {
        HashMap<String, BigDecimal> values = new HashMap<String, BigDecimal>();
        values.put("dddd", BigDecimal.valueOf(56.0));
        HashMap<String, String> formulas = new HashMap<String, String>();
        formulas.put("eeee", "#{dddd}*20");
        String expression = "(10000/(1+80/100.0)-20)*30/100.0";
        BigDecimal result = FormulaParser.parse(expression, formulas, values);
        System.out.println(result);
    }
}

