/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.util;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientUtil.class);

    public static URI buildQueryMessage(String url, Map<String, Object> paramMap) {
        String param = URLEncodedUtils.format(HttpClientUtil.setHttpParams(paramMap), (Charset)StandardCharsets.UTF_8);
        return URI.create(url + "?" + param);
    }

    public static String doGet(String url) throws IOException {
        return HttpClientUtil.doGet(url, null);
    }

    public static String doGet(String url, Map<String, Object> paramMap) throws IOException {
        logger.error("doGet url=" + url);
        HttpGet httpGet = new HttpGet();
        return HttpClientUtil.doRequest((HttpRequestBase)httpGet, url, paramMap);
    }

    public static String doDelete(String url) throws IOException {
        return HttpClientUtil.doDelete(url, null);
    }

    public static String doDelete(String url, Map<String, Object> paramMap) throws IOException {
        logger.error("doDelete url=" + url);
        HttpDelete httpDelete = new HttpDelete();
        return HttpClientUtil.doRequest((HttpRequestBase)httpDelete, url, paramMap);
    }

    public static String doPut(String url) throws IOException {
        return HttpClientUtil.doPut(url, null);
    }

    public static String doPut(String url, Map<String, Object> paramMap) throws IOException {
        logger.error("doPut url=" + url);
        HttpPut httpPut = new HttpPut();
        return HttpClientUtil.doRequest((HttpRequestBase)httpPut, url, paramMap);
    }

    public static String doPost(String url) throws Exception {
        return HttpClientUtil.doPost(url, null, null);
    }

    public static String doPost(String url, Map<String, Object> paramMap) throws Exception {
        return HttpClientUtil.doPost(url, paramMap, null);
    }

    public static String doPost(String url, Map<String, Object> paramMap, Map<String, String> headerMap) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        if (headerMap == null) {
            httpPost.addHeader("Content-Type", "application/json");
        } else {
            for (String key : headerMap.keySet()) {
                httpPost.addHeader(key, headerMap.get(key));
            }
        }
        if (null != paramMap && paramMap.size() > 0) {
            List<NameValuePair> nameValPair = HttpClientUtil.setHttpParams(paramMap);
            try {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nameValPair, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Exception("Failed to set request parameters {}" + e.getMessage() + e);
            }
        }
        return HttpClientUtil.executeHttp((HttpRequestBase)httpPost);
    }

    private static List<NameValuePair> setHttpParams(Map<String, Object> paramMap) {
        ArrayList<NameValuePair> nameValPair = new ArrayList<NameValuePair>();
        for (Map.Entry<String, Object> mapEntry : paramMap.entrySet()) {
            nameValPair.add((NameValuePair)new BasicNameValuePair(mapEntry.getKey(), mapEntry.getValue().toString()));
        }
        return nameValPair;
    }

    private static String doRequest(HttpRequestBase httpBase, String url, Map<String, Object> paramMap) throws IOException {
        if (paramMap == null) {
            httpBase.setURI(URI.create(url));
        } else {
            httpBase.setURI(HttpClientUtil.buildQueryMessage(url, paramMap));
        }
        return HttpClientUtil.executeHttp(httpBase);
    }

    private static String executeHttp(HttpRequestBase httpBase) throws IOException {
        String result;
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(1000).setSocketTimeout(60000).build();
        httpBase.setConfig(requestConfig);
        CloseableHttpClient httpClient = HttpClients.createDefault();
        CloseableHttpResponse httpResponse = null;
        try {
            httpResponse = httpClient.execute((HttpUriRequest)httpBase);
            HttpEntity entity = httpResponse.getEntity();
            result = EntityUtils.toString((HttpEntity)entity);
            httpBase.abort();
        }
        catch (IOException e) {
            throw new IOException("Failed to execute request or get response " + e.getMessage() + e);
        }
        finally {
            HttpClientUtil.closeHttpClientAndResp(httpClient, httpResponse);
        }
        return result;
    }

    private static void closeHttpClientAndResp(CloseableHttpClient httpClient, CloseableHttpResponse httpResponse) {
        if (null != httpResponse) {
            try {
                httpResponse.close();
            }
            catch (IOException e) {
                logger.error("Failed to close httpResponse {}" + e.getLocalizedMessage());
            }
        }
        if (null != httpClient) {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                logger.error("Failed to close httpClient {}" + e.getLocalizedMessage());
            }
        }
    }

    public static String customerClient(String region, String authToken) throws Exception {
        HttpPost httpPost = new HttpPost("http://v5qytl.test.baibaodun.cn/v3/tenant/users/get-user/region");
        CloseableHttpClient client = HttpClients.createDefault();
        String respContent = null;
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("region", (Object)region);
        StringEntity entity = new StringEntity(jsonParam.toString(), "utf-8");
        entity.setContentEncoding("UTF-8");
        entity.setContentType("application/json");
        httpPost.addHeader("Authorization", authToken);
        httpPost.setEntity((HttpEntity)entity);
        CloseableHttpResponse resp = client.execute((HttpUriRequest)httpPost);
        if (resp.getStatusLine().getStatusCode() == 200) {
            HttpEntity he = resp.getEntity();
            respContent = EntityUtils.toString((HttpEntity)he, (String)"UTF-8");
        }
        JSONObject jsonObject = JSONObject.parseObject(respContent);
        return respContent;
    }

    public static String doPostJson(String url, String jsonStr) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json;charset=utf-8");
        StringEntity entity = new StringEntity(jsonStr, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)entity);
        return HttpClientUtil.executeHttp((HttpRequestBase)httpPost);
    }

    public static String doPostJson(String url, String jsonStr, Map<String, String> headerMap) throws IOException {
        HttpPost httpPost = new HttpPost(url);
        if (headerMap == null) {
            httpPost.addHeader("Content-Type", "application/json");
        } else {
            for (String key : headerMap.keySet()) {
                httpPost.addHeader(key, headerMap.get(key));
            }
        }
        StringEntity entity = new StringEntity(jsonStr, ContentType.APPLICATION_JSON);
        httpPost.setEntity((HttpEntity)entity);
        return HttpClientUtil.executeHttp((HttpRequestBase)httpPost);
    }

    public static String isImagesTrue(String geturl) throws IOException {
        URL url = new URL(geturl);
        HttpURLConnection urlcon = (HttpURLConnection)url.openConnection();
        urlcon.setRequestMethod("GET");
        urlcon.setRequestProperty("Content-type", "application/x-www-form-urlencoded");
        if (urlcon.getResponseCode() == 200) {
            return "200";
        }
        return "404";
    }
}

