/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.obpm.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.exception.V5BusinessException;
import com.bcxin.auth.common.utils.DateUtils;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.domain.SysInterfaceLog;
import com.bcxin.auth.system.mapper.SysInterfaceLogMapper;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.dto.AuthLog;
import com.bcxin.obpm.dto.AuthenticationResult;
import com.bcxin.obpm.dto.BackgroundInfo;
import com.bcxin.obpm.dto.BackgroundResult;
import com.bcxin.obpm.dto.PerPhotoDto;
import com.bcxin.obpm.dto.beijing.PerInfoDto;
import com.bcxin.obpm.dto.beijing.PerInfoResult;
import com.bcxin.obpm.dto.beijing.Results;
import com.bcxin.obpm.dto.beijing.VerifyResult;
import com.bcxin.obpm.service.BackgroundService;
import com.bcxin.obpm.util.FaceUtil;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.http.HttpEntity;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="backgroundService_110000")
public class BJBackgroundServiceImpl
implements BackgroundService {
    private static Logger logger = LoggerFactory.getLogger(BJBackgroundServiceImpl.class);
    @Autowired
    private FaceUtil faceUtil;
    @Resource
    private ConfigUtil configUtil;
    @Autowired
    private SysInterfaceLogMapper sysInterfaceLogMapper;
    private final String BEIJING_PERSON_BASE_INFO_URL = "http://14.62.1.210:9006/zzxt/jk/helu/personBaseInfo";
    private final String BEIJING_PERSON_BASE_INFO_PHOTO_URL = "http://14.62.1.210:9006/zzxt/jk/rkk/ryhjglxxcx";
    private final String BEIJING_CHECK_PERSON_BASE_INFO_URL = "http://14.62.1.210:9006/zzxt/jk/helu/checkPersonBaseInfo";

    @Override
    public AjaxResult personnelReview(String idNumber, String realName) {
        if (StringUtils.isEmpty((String)idNumber)) {
            return AjaxResult.error((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        ArrayList<BackgroundInfo> backgroundInfoList = new ArrayList<BackgroundInfo>();
        List<String> unRemind = this.configUtil.getUnRemindList();
        BackgroundResult backgroundResult = new BackgroundResult();
        backgroundResult.setIdNumber(idNumber);
        backgroundResult.setCensorResult(backgroundInfoList);
        logger.info("\u8eab\u4efd\u8bc1{}\u7b5b\u67e5\u7ed3\u679c:{}", (Object)idNumber, (Object)backgroundResult);
        return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)backgroundResult);
    }

    private void checkPersonInfo(List<BackgroundInfo> list, String idNumber, List<String> unRemind) {
        SysInterfaceLog interfaceLog = new SysInterfaceLog();
        Boolean isSuccessful = true;
        try {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
            paramMap.put("deviceid", "60:EB:69:8F:82:9C");
            paramMap.put("policesfzh", "110226197803060034");
            paramMap.put("policename", "\u738b\u5149\u6656");
            paramMap.put("sfzh", idNumber);
            interfaceLog.setCreateTime(new Date());
            interfaceLog.setActive(true);
            interfaceLog.setUrl("http://14.62.1.210:9006/zzxt/jk/helu/checkPersonBaseInfo");
            interfaceLog.setParameters(JSONObject.toJSONString((Object)paramMap));
            HttpResponse response = ((HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createRequest((Method)Method.GET, (String)"http://14.62.1.210:9006/zzxt/jk/helu/checkPersonBaseInfo").form((Map)paramMap).timeout(30000).header("uid", "1100002200000700")).header("username", "baxt")).header("userpwd", "Bzxt*bzxt")).execute();
            String result = response.body();
            interfaceLog.setResult(result);
            logger.error("\u8eab\u4efd\u8bc1\u53f7:{},\u5317\u4eac\u6838\u67e5\u5e93\u8fd4\u56de\u6570\u636e:{}", (Object)idNumber, (Object)result);
            if (StringUtil.isNotEmpty((String)result)) {
                VerifyResult censorResult = (VerifyResult)JSONObject.parseObject((String)result, VerifyResult.class);
                if (censorResult.getStatus() != 0) {
                    throw new V5BusinessException("\u8c03\u7528\u63a5\u53e3\u5931\u8d25\uff1a".concat(censorResult.getMsg()));
                }
                List<Results> results = censorResult.getResults();
                if (results != null && !results.isEmpty()) {
                    for (Results item : results) {
                        boolean help = false;
                        for (int i = 0; i < unRemind.size(); ++i) {
                            String str = unRemind.get(i);
                            if (!str.equals(item.getValue())) continue;
                            help = true;
                            break;
                        }
                        if (help) continue;
                        BackgroundInfo backgroundInfo = new BackgroundInfo();
                        HashMap<String, Object> wfMap = new HashMap<String, Object>();
                        wfMap.put("detail", item.getValue());
                        backgroundInfo.setCode(200);
                        backgroundInfo.setData(wfMap);
                        backgroundInfo.setResult(1);
                        backgroundInfo.setCxxt("\u6838\u67e5\u5e93\u63a5\u53e3");
                        list.add(backgroundInfo);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            isSuccessful = false;
            interfaceLog.setResult(e.getMessage());
            throw new V5BusinessException("\u5317\u4eac\u6838\u67e5\u5e93\u8c03\u7528\u5f02\u5e38\uff01\uff01");
        }
        finally {
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(isSuccessful);
            new Thread(() -> this.sysInterfaceLogMapper.insert(interfaceLog)).start();
        }
    }

    @Override
    public AjaxResult getPersonnelInformation(String idNumber) {
        if (StringUtils.isEmpty((String)idNumber)) {
            return AjaxResult.error((String)"\u53c2\u6570\u4e0d\u6b63\u786e");
        }
        AuthenticationResult authenticationResult = new AuthenticationResult();
        authenticationResult.setIdNumber(idNumber);
        try {
            PerInfoResult perInfoResult;
            List<PerInfoDto> results;
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
            paramMap.put("deviceid", "60:EB:69:8F:82:9C");
            paramMap.put("policesfzh", "110226197803060034");
            paramMap.put("policename", "\u738b\u5149\u6656");
            paramMap.put("sfzh", idNumber);
            HttpResponse response = ((HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createRequest((Method)Method.GET, (String)"http://14.62.1.210:9006/zzxt/jk/helu/personBaseInfo").form((Map)paramMap).timeout(30000).header("uid", "1100002200000700")).header("username", "baxt")).header("userpwd", "Bzxt*bzxt")).execute();
            String result = response.body();
            logger.info("\u8eab\u4efd\u8bc1\u53f7:{},\u5317\u4eac\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u6570\u636e:{}", (Object)idNumber, (Object)result);
            if (StringUtil.isNotEmpty((String)result) && (results = (perInfoResult = (PerInfoResult)JSONObject.parseObject((String)result, PerInfoResult.class)).getResults()) != null && !results.isEmpty()) {
                PerInfoDto perInfoDto = results.get(0);
                authenticationResult.setRealName(perInfoDto.getName());
                authenticationResult.setPhoto(this.getPhoto(idNumber, perInfoDto.getName()));
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new V5BusinessException("\u5317\u4eac\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01\uff01");
        }
        logger.info("{}\u4eba\u5458\u4fe1\u606f\u670d\u52a1\u8fd4\u56de:{}", (Object)idNumber, (Object)authenticationResult);
        return AjaxResult.success((String)"\u8bf7\u6c42\u6210\u529f", (Object)authenticationResult);
    }

    private PerPhotoDto getPopulationInfo(String idnum, String name) {
        PerPhotoDto person;
        block11: {
            person = new PerPhotoDto();
            SysInterfaceLog interfaceLog = new SysInterfaceLog();
            Boolean isSuccessful = true;
            person.setIdNum(idnum);
            try {
                HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
                paramMap.put("device_id", "60:EB:69:8F:82:9C");
                paramMap.put("police_idcard", "110226197803060034");
                paramMap.put("police_name", "\u738b\u5149\u6656");
                paramMap.put("des_idcard", idnum);
                paramMap.put("des_name", name);
                logger.error("\u5317\u4eac\u4eba\u5458\u7167\u7247\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)paramMap));
                logger.error("\u5317\u4eac\u4eba\u5458\u7167\u7247\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u5730\u5740:{}", (Object)"http://14.62.1.210:9006/zzxt/jk/rkk/ryhjglxxcx");
                interfaceLog.setCreateTime(new Date());
                interfaceLog.setActive(true);
                interfaceLog.setUrl("http://14.62.1.210:9006/zzxt/jk/rkk/ryhjglxxcx");
                interfaceLog.setParameters(JSONObject.toJSONString((Object)paramMap));
                String result = this.postWithJson("http://14.62.1.210:9006/zzxt/jk/rkk/ryhjglxxcx", paramMap);
                if (!StringUtils.isNotEmpty((String)result)) break block11;
                JSONObject perInfoResult = JSONObject.parseObject((String)result);
                interfaceLog.setResult("\u8fd4\u56de\u7f16\u7801\uff1a" + perInfoResult.get((Object)"code").toString() + "\uff0c\u8fd4\u56de\u4fe1\u606f\uff1a" + perInfoResult.get((Object)"msg").toString());
                if ("0".equals(perInfoResult.get((Object)"code").toString())) {
                    if (perInfoResult.get((Object)"data") == null) break block11;
                    try {
                        JSONArray perInfoArr = JSONArray.parseArray((String)JSON.toJSONString((Object)perInfoResult.get((Object)"data")));
                        if (perInfoArr.size() > 0) {
                            JSONObject perInfo = JSON.parseObject((String)JSON.toJSONString((Object)perInfoArr.get(0)));
                            person.setName(name);
                            person.setPhoto(perInfo.get((Object)"XP").toString());
                        }
                        break block11;
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.error("\u5317\u4eac\u4eba\u5458\u7167\u7247\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\uff0c\u8fd4\u56de\u6570\u636e\u65e0\u7167\u7247\u4fe1\u606f");
                    }
                    break block11;
                }
                if (perInfoResult.get((Object)"msg") == null || !perInfoResult.get((Object)"msg").toString().contains("\u6ca1\u6709\u67e5\u8be2\u5230\u76f8\u5173\u4fe1\u606f")) {
                    throw new V5BusinessException("\u5317\u4eac\u4eba\u5458\u7167\u7247\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u5f02\u5e38!");
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                isSuccessful = false;
                interfaceLog.setResult(e.getMessage());
                throw new V5BusinessException("\u5317\u4eac\u4eba\u5458\u7167\u7247\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01\uff01");
            }
            finally {
                interfaceLog.setUpdateTime(new Date());
                interfaceLog.setSuccessful(isSuccessful);
                new Thread(() -> this.sysInterfaceLogMapper.insert(interfaceLog)).start();
            }
        }
        if (StringUtils.isEmpty((String)person.getName())) {
            person.setName(this.getName(idnum));
        }
        return person;
    }

    private String getName(String idNumber) {
        SysInterfaceLog interfaceLog = new SysInterfaceLog();
        Boolean isSuccessful = true;
        try {
            JSONArray perInfoArr;
            JSONObject perInfoDto;
            JSONObject perInfoResult;
            Object results;
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
            paramMap.put("deviceid", "60:EB:69:8F:82:9C");
            paramMap.put("policesfzh", "110226197803060034");
            paramMap.put("policename", "\u738b\u5149\u6656");
            paramMap.put("sfzh", idNumber);
            logger.error("\u8eab\u4efd\u8bc1\u53f7:{},\u5317\u4eac\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u5730\u5740:{}", (Object)idNumber, (Object)"http://14.62.1.210:9006/zzxt/jk/helu/personBaseInfo");
            logger.error("\u8eab\u4efd\u8bc1\u53f7:{},\u5317\u4eac\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)idNumber, (Object)JSON.toJSONString((Object)paramMap));
            HttpResponse response = ((HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createRequest((Method)Method.GET, (String)"http://14.62.1.210:9006/zzxt/jk/helu/personBaseInfo").form((Map)paramMap).timeout(30000).header("uid", "1100002200000700")).header("username", "baxt")).header("userpwd", "Bzxt*bzxt")).execute();
            interfaceLog.setCreateTime(new Date());
            interfaceLog.setActive(true);
            interfaceLog.setUrl("http://14.62.1.210:9006/zzxt/jk/helu/personBaseInfo");
            interfaceLog.setParameters(JSONObject.toJSONString((Object)paramMap));
            String result = response.body();
            interfaceLog.setResult(result);
            logger.error("\u8eab\u4efd\u8bc1\u53f7:{},\u5317\u4eac\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u6570\u636e:{}", (Object)idNumber, (Object)result);
            if (StringUtils.isNotEmpty((String)result) && (results = (perInfoResult = JSONObject.parseObject((String)result)).get((Object)"results")) != null && (perInfoDto = JSONObject.parseObject((String)JSON.toJSONString((Object)(perInfoArr = JSONArray.parseArray((String)JSON.toJSONString((Object)results))).get(0)))).get((Object)"name") != null) {
                String string = perInfoDto.get((Object)"name").toString();
                return string;
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            isSuccessful = false;
            interfaceLog.setResult(e.getMessage());
            throw new V5BusinessException("\u5317\u4eac\u4eba\u5458\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01\uff01");
        }
        finally {
            interfaceLog.setUpdateTime(new Date());
            interfaceLog.setSuccessful(isSuccessful);
            new Thread(() -> this.sysInterfaceLogMapper.insert(interfaceLog)).start();
        }
        return "";
    }

    private String getPhoto(String idNumber, String name) {
        try {
            HashMap paramMap = Maps.newHashMapWithExpectedSize((int)8);
            paramMap.put("device_id", "60:EB:69:8F:82:9C");
            paramMap.put("police_idcard", "110226197803060034");
            paramMap.put("police_name", "\u738b\u5149\u6656");
            paramMap.put("des_idcard", idNumber);
            paramMap.put("des_name", name);
            logger.error("\u5317\u4eac\u4eba\u5458\u7167\u7247\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)paramMap));
            logger.error("\u5317\u4eac\u4eba\u5458\u7167\u7247\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8bf7\u6c42\u5730\u5740:{}", (Object)"http://14.62.1.210:9006/zzxt/jk/rkk/ryhjglxxcx");
            String result = this.postWithJson("http://14.62.1.210:9006/zzxt/jk/rkk/ryhjglxxcx", paramMap);
            logger.error("\u8eab\u4efd\u8bc1\u53f7:{},\u5317\u4eac\u4eba\u5458\u7167\u7247\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8fd4\u56de\u6570\u636e:{}", (Object)idNumber, (Object)result);
            if (StringUtil.isNotEmpty((String)result)) {
                JSONArray perInfoArr;
                JSONObject perInfoResult = JSONObject.parseObject((String)result);
                if (perInfoResult.get((Object)"msg") != null && perInfoResult.get((Object)"msg").toString().equals("\u672a\u6388\u6743\u7684IP\u5730\u5740")) {
                    throw new V5BusinessException("\u5317\u4eac\u4eba\u5458\u7167\u7247\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38 -- \u672a\u6388\u6743\u7684IP\u5730\u5740");
                }
                if (perInfoResult.get((Object)"data") != null && (perInfoArr = JSONArray.parseArray((String)JSON.toJSONString((Object)perInfoResult.get((Object)"data")))).size() > 0) {
                    JSONObject perInfo = JSON.parseObject((String)JSON.toJSONString((Object)perInfoArr.get(0)));
                    return perInfo.get((Object)"XP").toString();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new V5BusinessException("\u5317\u4eac\u4eba\u5458\u7167\u7247\u57fa\u672c\u4fe1\u606f\u63a5\u53e3\u8c03\u7528\u5f02\u5e38\uff01\uff01");
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<AuthLog> validateResult(List<AuthLog> list) {
        for (AuthLog authLog2 : list) {
            try {
                this.matchResult(authLog2);
                authLog2.setAuthDate(DateUtils.getNowDate());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return list.stream().filter(authLog -> StrUtil.isNotEmpty((CharSequence)authLog.getAuthStatus())).collect(Collectors.toList());
    }

    @Override
    public void getPersonnelAddress(String idNumber) {
    }

    private String postWithJson(String requestUrl, Map<String, Object> paramMap) throws Exception {
        String returnValue = "";
        CloseableHttpClient httpClient = HttpClients.createDefault();
        BasicResponseHandler responseHandler = new BasicResponseHandler();
        try {
            httpClient = HttpClients.createDefault();
            HttpPost httpPost = new HttpPost(requestUrl);
            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(30000);
            requestConfig.setConnectionRequestTimeout(30000);
            requestConfig.setSocketTimeout(30000);
            StringEntity requestEntity = new StringEntity(JSON.toJSONString(paramMap), "utf-8");
            requestEntity.setContentEncoding("UTF-8");
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader("uid", "1100002200000700");
            httpPost.setHeader("username", "baxt");
            httpPost.setHeader("userpwd", "Baxt*RKK");
            httpPost.setConfig(requestConfig.build());
            httpPost.setEntity((HttpEntity)requestEntity);
            returnValue = (String)httpClient.execute((HttpUriRequest)httpPost, (ResponseHandler)responseHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }

    public void matchResult(AuthLog authLog) throws IOException {
        try {
            PerPhotoDto person = this.getPopulationInfo(authLog.getIdNumber(), authLog.getSecurityName());
            String xp = "";
            String name = person.getName();
            if (StrUtil.isEmpty((CharSequence)name)) {
                authLog.setAuthStatus("2");
                authLog.setAuthResult("\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
            } else if (name.equals(authLog.getSecurityName())) {
                xp = person.getPhoto();
                if (StrUtil.isEmpty((CharSequence)xp)) {
                    authLog.setAuthStatus("2");
                    authLog.setAuthResult("\u4eba\u53e3\u5e93\u65e0\u7167\u7247\u3002\u8bf7\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
                }
            } else {
                authLog.setAuthStatus("2");
                authLog.setAuthResult("\u59d3\u540d\u4e0e\u8eab\u4efd\u8bc1\u53f7\u4e0d\u4e00\u81f4\u3002\u8bf7\u4fee\u6539\u4fe1\u606f\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
            }
            if (StrUtil.isNotEmpty((CharSequence)xp)) {
                if (xp.trim().startsWith("http")) {
                    logger.error("\u5728\u7ebf\u5730\u5740\u8f6cbase64");
                    String suffix = ".jpg";
                    if (!xp.matches(".*access_token.*")) {
                        suffix = xp.substring(xp.lastIndexOf("."));
                    }
                    String filePath = BMSConfig.getTempPath() + UUID.randomUUID().toString() + suffix;
                    this.faceUtil.downloadFile(xp, filePath);
                    xp = this.faceUtil.ImageToBase64(filePath);
                    FileUtil.del((String)filePath);
                }
                if (this.faceUtil.matchResult(xp, this.faceUtil.ImageToBase64(authLog.getImgPath()))) {
                    authLog.setAuthStatus("3");
                    authLog.setAuthResult("\u8ba4\u8bc1\u6210\u529f");
                } else {
                    authLog.setAuthStatus("2");
                    authLog.setAuthResult("\u4eba\u8138\u7167\u7247\u4e0e\u8eab\u4efd\u8bc1\u53f7\u4e0d\u4e00\u81f4\u3002\u8bf7\u91cd\u65b0\u91c7\u96c6\u4eba\u8138\u6216\u5230\u6d3e\u51fa\u6240\u66f4\u65b0\u8eab\u4efd\u8bc1\u4fe1\u606f\u540e\u91cd\u65b0\u8ba4\u8bc1\u3002");
                }
            }
            authLog.setAuthDate(DateUtils.getNowDate());
        }
        catch (Exception e) {
            authLog.setAuthStatus("1");
            authLog.setAuthResult("\u6bd4\u5bf9\u63a5\u53e3\u5f02\u5e38\uff01\uff01");
            e.printStackTrace();
        }
    }
}

