/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.system.service.impl;

import com.bcxin.auth.common.core.domain.Ztree;
import com.bcxin.auth.common.core.domain.entity.SysMenu;
import com.bcxin.auth.common.core.domain.entity.SysRole;
import com.bcxin.auth.common.core.domain.entity.SysUser;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.mapper.SysMenuMapper;
import com.bcxin.auth.system.mapper.SysRoleMenuMapper;
import com.bcxin.auth.system.service.ISysMenuService;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysMenuServiceImpl
implements ISysMenuService {
    public static final String PREMISSION_STRING = "perms[\"{0}\"]";
    @Autowired
    private SysMenuMapper menuMapper;
    @Autowired
    private SysRoleMenuMapper roleMenuMapper;

    @Override
    public List<SysMenu> selectMenusByUser(SysUser user) {
        List<Object> menus = new LinkedList();
        menus = user.isAdmin() ? this.menuMapper.selectMenuNormalAll() : this.menuMapper.selectMenusByUserId(user.getUserId());
        return this.getChildPerms(menus, 0);
    }

    @Override
    public List<SysMenu> selectMenuList(SysMenu menu, Long userId) {
        List<SysMenu> menuList = null;
        if (SysUser.isAdmin((Long)userId)) {
            menuList = this.menuMapper.selectMenuList(menu);
        } else {
            menu.getParams().put("userId", userId);
            menuList = this.menuMapper.selectMenuListByUserId(menu);
        }
        return menuList;
    }

    @Override
    public List<SysMenu> selectMenuAll(Long userId) {
        List<SysMenu> menuList = null;
        menuList = SysUser.isAdmin((Long)userId) ? this.menuMapper.selectMenuAll() : this.menuMapper.selectMenuAllByUserId(userId);
        return menuList;
    }

    @Override
    public Set<String> selectPermsByUserId(Long userId) {
        List<String> perms = this.menuMapper.selectPermsByUserId(userId);
        HashSet<String> permsSet = new HashSet<String>();
        for (String perm : perms) {
            if (!StringUtils.isNotEmpty((String)perm)) continue;
            permsSet.addAll(Arrays.asList(perm.trim().split(",")));
        }
        return permsSet;
    }

    @Override
    public List<Ztree> roleMenuTreeData(SysRole role, Long userId) {
        Long roleId = role.getRoleId();
        List<Object> ztrees = new ArrayList();
        List<SysMenu> menuList = this.selectMenuAll(userId);
        if (StringUtils.isNotNull((Object)roleId)) {
            List<String> roleMenuList = this.menuMapper.selectMenuTree(roleId);
            ztrees = this.initZtree(menuList, roleMenuList, true);
        } else {
            ztrees = this.initZtree(menuList, null, true);
        }
        return ztrees;
    }

    @Override
    public List<Ztree> menuTreeData(Long userId) {
        List<SysMenu> menuList = this.selectMenuAll(userId);
        List<Ztree> ztrees = this.initZtree(menuList);
        return ztrees;
    }

    public LinkedHashMap<String, String> selectPermsAll(Long userId) {
        LinkedHashMap<String, String> section = new LinkedHashMap<String, String>();
        List<SysMenu> permissions = this.selectMenuAll(userId);
        if (StringUtils.isNotEmpty(permissions)) {
            for (SysMenu menu : permissions) {
                section.put(menu.getUrl(), MessageFormat.format(PREMISSION_STRING, menu.getPerms()));
            }
        }
        return section;
    }

    public List<Ztree> initZtree(List<SysMenu> menuList) {
        return this.initZtree(menuList, null, false);
    }

    public List<Ztree> initZtree(List<SysMenu> menuList, List<String> roleMenuList, boolean permsFlag) {
        ArrayList<Ztree> ztrees = new ArrayList<Ztree>();
        boolean isCheck = StringUtils.isNotNull(roleMenuList);
        for (SysMenu menu : menuList) {
            Ztree ztree = new Ztree();
            ztree.setId(menu.getMenuId());
            ztree.setpId(menu.getParentId());
            ztree.setName(this.transMenuName(menu, permsFlag));
            ztree.setTitle(menu.getMenuName());
            if (isCheck) {
                ztree.setChecked(roleMenuList.contains(menu.getMenuId() + menu.getPerms()));
            }
            ztrees.add(ztree);
        }
        return ztrees;
    }

    public String transMenuName(SysMenu menu, boolean permsFlag) {
        StringBuffer sb = new StringBuffer();
        sb.append(menu.getMenuName());
        if (permsFlag) {
            sb.append("<font color=\"#888\">&nbsp;&nbsp;&nbsp;" + menu.getPerms() + "</font>");
        }
        return sb.toString();
    }

    @Override
    public int deleteMenuById(Long menuId) {
        return this.menuMapper.deleteMenuById(menuId);
    }

    @Override
    public SysMenu selectMenuById(Long menuId) {
        return this.menuMapper.selectMenuById(menuId);
    }

    @Override
    public int selectCountMenuByParentId(Long parentId) {
        return this.menuMapper.selectCountMenuByParentId(parentId);
    }

    @Override
    public int selectCountRoleMenuByMenuId(Long menuId) {
        return this.roleMenuMapper.selectCountRoleMenuByMenuId(menuId);
    }

    @Override
    public int insertMenu(SysMenu menu) {
        return this.menuMapper.insertMenu(menu);
    }

    @Override
    public int updateMenu(SysMenu menu) {
        return this.menuMapper.updateMenu(menu);
    }

    @Override
    public String checkMenuNameUnique(SysMenu menu) {
        Long menuId = StringUtils.isNull((Object)menu.getMenuId()) ? -1L : menu.getMenuId();
        SysMenu info = this.menuMapper.checkMenuNameUnique(menu.getMenuName(), menu.getParentId());
        if (StringUtils.isNotNull((Object)info) && info.getMenuId().longValue() != menuId.longValue()) {
            return "1";
        }
        return "0";
    }

    public List<SysMenu> getChildPerms(List<SysMenu> list, int parentId) {
        ArrayList<SysMenu> returnList = new ArrayList<SysMenu>();
        for (SysMenu t : list) {
            if (t.getParentId() != (long)parentId) continue;
            this.recursionFn(list, t);
            returnList.add(t);
        }
        return returnList;
    }

    private void recursionFn(List<SysMenu> list, SysMenu t) {
        List<SysMenu> childList = this.getChildList(list, t);
        t.setChildren(childList);
        for (SysMenu tChild : childList) {
            if (!this.hasChild(list, tChild)) continue;
            this.recursionFn(list, tChild);
        }
    }

    private List<SysMenu> getChildList(List<SysMenu> list, SysMenu t) {
        ArrayList<SysMenu> tlist = new ArrayList<SysMenu>();
        for (SysMenu n : list) {
            if (n.getParentId().longValue() != t.getMenuId().longValue()) continue;
            tlist.add(n);
        }
        return tlist;
    }

    private boolean hasChild(List<SysMenu> list, SysMenu t) {
        return this.getChildList(list, t).size() > 0;
    }
}

