package com.bcxin.obpm.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.BASE64Encoder;

import javax.imageio.ImageIO;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class ImageProcessEnding {

    /**
     *
     * description 网络图片转换成字节数组
     * @param imgUrl
     * @return byte[]
     */
    /**
     * 日志对象
     */
    private static final Logger logger = LoggerFactory.getLogger(ImageProcessEnding.class);

    public static byte[] getImgUrlToByte(String imgUrl) {
        InputStream inputStream = null;
        ByteArrayOutputStream outputStream = null;
        byte[] buffer = null;
        try {
            // 创建URL
            URL url = new URL(imgUrl);
            // 创建链接
            HttpURLConnection conn = (HttpURLConnection) url.openConnection();
            conn.setRequestMethod("GET");
            conn.setConnectTimeout(5000);
            inputStream = conn.getInputStream();
            outputStream = new ByteArrayOutputStream();
            // 将内容读取内存中
            buffer = new byte[1024];
            int len = -1;
            while ((len = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, len);
            }
            buffer = outputStream.toByteArray();
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (inputStream != null) {
                try {
                    // 关闭inputStream流
                    inputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    // 关闭outputStream流
                    outputStream.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        // 对字节数组Base64编码
        return buffer;
    }



    /**
     *  descreiption
     *  通过图片的byte字节数组将图片进行压缩
     * @param imageByte
     * @param ppi
     * @return byte[]
     */
    public static byte[] compressImage(byte[] imageByte ,int ppi){

        byte[] smallImage = null;
        int width = 0 ;
        int height = 0;
        if (imageByte == null) {
            logger.error("compressImage（）==》 网络图片资源提取失败");
//            System.out.println("compressImage（）==》 网络图片资源提取失败");
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(imageByte);
        try{
            Image image = ImageIO.read(byteArrayInputStream);
            int w = image.getWidth(null);
            int h = image.getHeight(null);
            double scale = 0 ;
            scale = Math.min((float)ppi/w,(float)ppi/h);
            width =(int)(w*scale);
            width -= width % 4 ;
            height = (int)(h*scale);
            if(scale>=(double)1)return imageByte;

            BufferedImage bufferedImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
            bufferedImage.getGraphics().drawImage(image.getScaledInstance(width,height,image.SCALE_SMOOTH),0,0,null);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write(bufferedImage,"png",out);
            smallImage = out.toByteArray();
            return smallImage;
        } catch (IOException e) {
            e.printStackTrace();
            logger.error("图片压缩失败");
            return null;
        }
    }

    /**
     *
     * 将图片的字节吗准换成base64编码
     */
//    传入图片字节数据将图片转为base64编码
    public  static  String ImageByteToBaseCode(byte[] data) {
        //返回base编码的字节数组字符串
        String encode = null;
        BASE64Encoder encoder = new BASE64Encoder();
        encode = encoder.encode(data);
        return encode;
    }


}
