package com.bcxin.obpm.service;

import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.obpm.dto.AuthLog;

import java.util.List;

/**
 * @author linqinglin
 * @date 2021/08/19 0019 10:23
 */
public interface BackgroundService {

    /**
     * 根据身份证对人员进行背景审查
     * @param idNumber 身份证
     * @return {@link AjaxResult}
     */
    AjaxResult personnelReview(String idNumber,String realName);

    /**
     * 获取人员信息
     * @param idNumber 身份证号
     * @return {@link AjaxResult}
     */
    AjaxResult getPersonnelInformation(String idNumber);

    /**
     * 认证比对
     * @param list
     * @return
     */
    List<AuthLog> validateResult(List<AuthLog> list);

    /**
     * 获取人员人口库地址
     */
    void getPersonnelAddress(String idNumber);


}
