package com.bcxin.obpm.ministerial;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.auth.common.config.BMSConfig;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.utils.IdWorker;
import com.bcxin.auth.common.utils.file.FileUtils;
import com.bcxin.auth.system.service.ISysConfigService;
import com.bcxin.auth.system.service.impl.SysConfigServiceImpl;
import com.bcxin.auth.system.util.ConfigUtil;
import com.bcxin.obpm.annotation.MinisterialAttr;
import com.bcxin.obpm.dto.PhotoDto;
import com.bcxin.obpm.util.FaceUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.io.File;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.List;

/**
 * 照片处理
 *
 * @author zhangyutong
 */
@Component
public class PhotoMinDataFormatStrategy implements MinDataFormatStrategy {

    @Autowired
    private ConfigUtil configUtil;
    @Autowired
    private FaceUtil faceUtil;
    @Autowired
    private IdWorker idWorker;


    @Override
    public String format(Field columnField, Object data) {
        if(data == null){
            MinisterialAttr resource = columnField.getAnnotation(MinisterialAttr.class);
            return resource.defaultValue();
        }
        String path =(String) data;
        try {
            List<PhotoDto> photoDtos = JSONArray.parseArray(path, PhotoDto.class);
            PhotoDto photoDto = photoDtos.get(0);
            String filePath=photoDto.getPath();
            System.out.println("部级系统-----------------------photodto："+photoDto.toString());
            String fileName="";
            long nextId=idWorker.nextId();
            if (photoDto.getName()==null|| photoDto.getName().equals("")){
                filePath=filePath.replaceAll("%2F","/");
                //System.out.println("部级系统-----------------------filePath"+filePath);
                //System.out.println("部级系统-----------------------nextId"+nextId);
                fileName =  nextId+ filePath.substring(filePath.lastIndexOf("/")+1);
            }else {
                fileName = nextId + photoDto.getName();
            }
            //System.out.println("部级系统-----------------------文件名称："+fileName);
            File file = new File(BMSConfig.getTempPath() + fileName);
            String fileNewPath="";
            if (filePath.contains("http")){
                fileNewPath=filePath;
            }else {
                fileNewPath=configUtil.getV5URL()+ filePath;
            }

            URL url = new URL(fileNewPath);
            FileUtils.copyURLToFile(url, file, 30000, 30000);
            if (file.exists()) {
                path = faceUtil.ImageToBase64(file.getAbsolutePath());
                //System.out.println("部级系统-----------------------path："+path);
                file.delete();
                return path;
            }
        }catch (Exception e){
            e.printStackTrace();
        }


        return null;
    }
}
