package com.bcxin.obpm.domain;

import com.bcxin.auth.common.core.domain.BaseEntity;
import lombok.Data;

import java.sql.Timestamp;

/**
 * 租户用户
 * tenant_users
 */
@Data
public class TenantUser extends BaseEntity {

    private static final long serialVersionUID = 1L;

    private String id;

    /**
     * 姓名
     */
    private String name;

    /**
     * 头像
     */
    private String headPhoto;

    /**
     * 核验状态
     */
    private String checkedStatus;

    /**
     * 实名认证状态
     */
    private String authenticateStatus;

    /**
     * 实名认证结果
     */
    private String authenticatedResult;

    /**
     * 实名认证时间
     */
    private Timestamp authenticatedTime;

    /**
     * 一寸免冠白底彩照
     */
    private String oneInchColorWhitePhoto;

    /**
     * 两寸免冠蓝底彩照
     */
    private String twoInchColorBluePhoto;

    private Timestamp lastUpdatedTime;

}
