package com.bcxin.auth.system.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.bcxin.auth.common.constant.Constants;
import com.bcxin.auth.common.utils.StringUtils;
import com.bcxin.auth.system.domain.ComCerDto;
import com.bcxin.auth.system.domain.PerCerDto;
import com.bcxin.auth.system.mapper.ComCerMapper;
import com.bcxin.auth.system.mapper.PerCerMapper;
import com.bcxin.auth.system.service.ComCerService;
import com.bcxin.auth.system.service.PerCerService;
import com.google.common.collect.Maps;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.List;
import java.util.Map;

@Service
public class ComCerServiceImpl implements ComCerService {
    private static Logger logger = LoggerFactory.getLogger(ComCerServiceImpl.class);

    @Autowired
    private ComCerMapper comCerMapper;


    @Override
    public int insert(ComCerDto comCerDto) {
        return comCerMapper.insertComCer(comCerDto);
    }

    @Override
    public void update(ComCerDto comCerDto) {
        comCerMapper.updateComCer(comCerDto);
    }

    @Override
    public void updatePrintState(ComCerDto comCerDto) {
        comCerMapper.updatePrintState(comCerDto);
    }

    @Override
    public void updateCallBackState(ComCerDto comCerDto) {
        comCerMapper.updateCallBackState(comCerDto);
    }

    @Override
    public void cancelPrint(ComCerDto comCerDto) {
        comCerMapper.cancelPrint(comCerDto);
    }

    @Override
    public String generatePrintRecord(ComCerDto comCerDto) {
        Map<String, Object> params = Maps.newHashMap();
        //生产记录的id
        params.put("id", comCerDto.getBusinessid());
        params.put("printDate", comCerDto.getPrintDate());
        params.put("printOrganization", comCerDto.getPrintorganization());
        params.put("printPeople", comCerDto.getPrintpeople());
        String zf="";
        if (comCerDto.getZf().equals("z")){
            zf="正本";
        }else {
            zf="副本";
        }
        params.put("certificateType",zf);
        //链式构建请求
        String returnValue = StringUtils.EMPTY;
        CloseableHttpClient httpClient = HttpClients.createDefault();
        ResponseHandler<String> responseHandler = new BasicResponseHandler();
        try{
            //第一步：创建HttpClient对象
            httpClient = HttpClients.createDefault();
            //第二步：创建httpPost对象
            HttpPost httpPost = new HttpPost(comCerDto.getCall_back_url());
            RequestConfig.Builder requestConfig = RequestConfig.custom();
            requestConfig.setConnectTimeout(Constants.TIMEOUT);
            requestConfig.setConnectionRequestTimeout(Constants.TIMEOUT);
            requestConfig.setSocketTimeout(Constants.TIMEOUT);
            //第三步：给httpPost设置JSON格式的参数
            StringEntity requestEntity = new StringEntity(JSON.toJSONString(params),"utf-8");
            requestEntity.setContentEncoding("UTF-8");
            System.out.println(requestEntity);
            httpPost.setHeader("Content-type", "application/json");
            httpPost.setHeader(Constants.ACCESS_TOKEN,comCerDto.getAccess_token());
            System.out.println(httpPost);
            httpPost.setConfig(requestConfig.build());
            httpPost.setEntity(requestEntity);
            //第四步：发送HttpPost请求，获取返回值
            returnValue = httpClient.execute(httpPost,responseHandler); //调接口获取返回值时，必须用此方法
        }catch(Exception e){
            e.printStackTrace();
        }finally {
            try {
                httpClient.close();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return returnValue;
    }


    @Override
    public List<ComCerDto> findUnUploadRecord() {
        return comCerMapper.findUnUploadRecord();
    }

    @Override
    public ComCerDto findById(String id) {
        return comCerMapper.findById(id);
    }
}
