package com.bcxin.statistics.service.v5;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.statistics.dao.mapper.TenantEmployeesMapper;
import com.bcxin.statistics.dtos.response.BcxEmployeeResponse;
import com.bcxin.statistics.entity.TenantEmployeesEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * description：智能人事-职员表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TenantEmployeesService extends ServiceImpl<TenantEmployeesMapper, TenantEmployeesEntity> {

    /**
     * description：获取组织管理员
     * author：linchunpeng
     * date：2025/1/6
     */
    public TenantEmployeesEntity getAdminByOrgId(String orgId) {
        LambdaQueryChainWrapper<TenantEmployeesEntity> lqw = this.lambdaQuery();
        lqw.eq(TenantEmployeesEntity::getOrganizationId, orgId);
        lqw.eq(TenantEmployeesEntity::getIsDomainAdmin, 1);
        lqw.eq(TenantEmployeesEntity::getStatus, 0);
        lqw.orderByAsc(TenantEmployeesEntity::getCreatedTime);
        return lqw.list().get(0);
    }

    /**
     * description：判断是不是组织管理员
     * author：linchunpeng
     * date：2025/1/6
     */
    public boolean isAdminByOrgIdAndEmployeeId(String orgId, String employeeId) {
        LambdaQueryChainWrapper<TenantEmployeesEntity> lqw = this.lambdaQuery();
        lqw.eq(TenantEmployeesEntity::getOrganizationId, orgId);
        lqw.eq(TenantEmployeesEntity::getId, employeeId);
        lqw.eq(TenantEmployeesEntity::getIsDomainAdmin, 1);
        lqw.eq(TenantEmployeesEntity::getStatus, 0);
        return lqw.exists();
    }

    /**
     * description：获取职员列表
     * author：linchunpeng
     * date：2025/1/6
     */
    public List<TenantEmployeesEntity> getByOrgId(String orgId) {
        LambdaQueryChainWrapper<TenantEmployeesEntity> lqw = this.lambdaQuery();
        lqw.eq(TenantEmployeesEntity::getOrganizationId, orgId);
        lqw.eq(TenantEmployeesEntity::getStatus, 0);
        return lqw.list();
    }

    /**
     * description：获取组织所有员工
     * author：linchunpeng
     * date：2025/1/6
     */
    public List<BcxEmployeeResponse> getEmployeeResponseListByOrganizationId(String organizationId, Integer status) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("organizationId", organizationId);
        paramMap.put("status", status);
        if (status != null && status == 0) {
            //在职
            paramMap.put("approvedInformationStatus", 1);
        }
        return getBcxEmployeeResponseList(paramMap);
    }

    /**
     * description：根据员工id列表，获取员工
     * author：linchunpeng
     * date：2025/1/6
     */
    public List<BcxEmployeeResponse> getEmployeeResponseListByEmployeeIdList(List<String> employeeIdList, Integer status) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("idList", employeeIdList);
        paramMap.put("status", status);
        if (status != null && status == 0) {
            //在职
            paramMap.put("approvedInformationStatus", 1);
        }
        return getBcxEmployeeResponseList(paramMap);
    }

    /**
     * description：根据用户id列表，获取员工
     * author：linchunpeng
     * date：2025/1/6
     */
    public List<BcxEmployeeResponse> getEmployeeResponseListByUserIdList(List<String> userIdList, Integer status) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("userIdList", userIdList);
        paramMap.put("status", status);
        if (status != null && status == 0) {
            //在职
            paramMap.put("approvedInformationStatus", 1);
        }
        return getBcxEmployeeResponseList(paramMap);
    }

    /**
     * description：获取员工列表
     * author：linchunpeng
     * date：2025/3/27
     */
    private List<BcxEmployeeResponse> getBcxEmployeeResponseList(Map<String, Object> paramMap) {
        List<BcxEmployeeResponse> list = new ArrayList<>();
        list.addAll(baseMapper.selectBcxEmployeeList(paramMap));
        list.addAll(baseMapper.selectExternalMemberList(paramMap));
        return list;
    }

}