package com.wlos.app.vo;



import java.time.*;
import com.wlos.app.dto.CommonFileDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;

/**
 * 任务信息 数据查询通用VO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:34 PM
 * @since v0.1
 */
@Data
public class SurveyTaskVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 任务名称
     */
    private String name;

    /**
     * 活动ID
     */
    private Long activityId;

    /**
     * 活动开始时间
     */
    private LocalDateTime starTime;

    /**
     * 活动结束时间
     */
    private LocalDateTime endTime;

    /**
     * 活动地址
     */
    private String address;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String contactMobile;

    /**
     * 状态（0:未接受;1:进行中;2:已办结;2:已办结;3:退回;9:已超时;）
     */
    private String surveyTaskStatus;

    /**
     * 接受时间
     */
    private LocalDateTime acceptTime;

    /**
     * 完成时间
     */
    private LocalDateTime finishTime;

    /**
     * 踏勘人员ID
     */
    private Long userId;

    /**
     * 场馆ID
     */
    private Long venueId;

    /**
     * 主站任务ID
     */
    private Long taskId;

    /**
     * 地址类型
     */
    private String address_type;

    /**
     * 活动类型
     */
    private String activity_type;

    /**
     * 市编码
     */
    private String city;

    /**
     * 省编码
     */
    private String province;



}