package com.wlos.app.vo;



import java.time.*;
import com.wlos.app.dto.CommonFileDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;

/**
 * 勘查计划 数据查询通用VO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:28 PM
 * @since v0.1
 */
@Data
public class SurveyPlanVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 总共天数
     */
    private Boolean allDay;

    /**
     * 踏勘开始时间
     */
    private LocalDateTime beginTime;

    /**
     * 踏勘结束时间
     */
    private LocalDateTime endTime;

    /**
     * 承办方负责人签字
     */
    private String purveyorSignPath;

    /**
     * 备注
     */
    private String remark;

    /**
     * 客户经理签字
     */
    private String signImgPath;

    /**
     * 踏勘阶段
     */
    private String surveyStep;

    /**
     * 踏勘状态
     */
    private String taskStatus;

    /**
     * 踏勘次数
     */
    private Integer time;

    /**
     * 对应踏勘阶段
     */
    private Long feedbackId;

    /**
     * 对应踏勘场地问题
     */
    private Long questionnaireId;

    /**
     * 踏勘任务ID
     */
    private Long taskId;

    /**
     * 用户ID
     */
    private Long userId;

    /**
     * 场地ID
     */
    private Long venueId;



}