package com.wlos.app.vo;



import java.time.*;
import com.wlos.app.dto.CommonFileDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;

/**
 * 查勘现场具体问题及反馈详情 数据查询通用VO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Data
public class SurveyInfoVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 踏勘结果
     */
    private String answer;

    /**
     * 关联上次踏勘ID
     */
    private String lastSurveyInfoId;

    /**
     * 是否下次踏勘
     */
    private Integer nextSurvey;

    /**
     * 该问题是否已回答
     */
    private Integer replied;

    /**
     * 活动场馆阶段问卷ID
     */
    private Long questionnaireId;

    /**
     * 整改意见ID
     */
    private Long reformId;

    /**
     * 附件信息
     */
    private String urls;



}