package com.wlos.app.vo;



import java.time.*;
import com.wlos.app.dto.CommonFileDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;

/**
 * 勘查协助 数据查询通用VO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@Data
public class SurveyAssistVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 创建时间
     */
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    private LocalDateTime modificationTime;

    /**
     * 分配状态(0未审批;1不通过;2通过;9关闭)
     */
    private String assignStatus;

    /**
     * 分配类型(0任务转交;1申请专家)
     */
    private String assignType;

    /**
     * 申请的专家
     */
    private Object experts;

    /**
     * 申请原因
     */
    private String reason;

    /**
     * 踏勘阶段
     */
    private String surveyStep;

    /**
     * 接受者
     */
    private Long accepterId;

    /**
     * 踏勘任务ID
     */
    private Long taskId;

    /**
     * 用户ID
     */
    private Long userId;



}