package com.wlos.app.vo;



import java.time.*;
import com.wlos.app.dto.CommonFileDTO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import lombok.Data;
import java.io.Serial;

/**
 * 固定问题表 数据查询通用VO
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@Data
public class BaseFixedIssueVO implements Serializable {
    @Serial
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    private String id;

    /**
     * 踏勘题目
     */
    private String question;

    /**
     * 结果提示
     */
    private String answerTip;

    /**
     * 排序编号
     */
    private Integer sort;

    /**
     * 是否固定(是,否)
     */
    private String isFixed;

    /**
     * 踏勘阶段(第1阶段,第2阶段,第3阶段)
     */
    private String surveyStep;

    /**
     * 活动类型
     */
    private String activityType;

    /**
     * 地址类型
     */
    private String addressType;

    /**
     * 是否通用，1是，0否
     */
    private String gm;



}