package com.wlos.app.utils;

import cn.hutool.http.ContentType;
import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.wlos.app.exception.BusinessException;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.Map;

/**
 * http请求工具类
 * @author
 * @date 2024-08-30 17:02:53
 */
public class HttpUtils {

    protected static Logger log = LoggerFactory.getLogger(HttpUtils.class);

    /**
     * http请求
     * @param url
     * @param paramsMap
     * @param headerMap
     * @param contentType
     * @param requestMethod
     * @return
     * @throws
     */
    public static String doHttp(String url, Map paramsMap, Map headerMap, String contentType, String requestMethod, Integer timeout) throws BusinessException{
        if (ObjectUtils.isEmpty(timeout)) {
            //默认设置不超时
            timeout = -1;
        }
        if (requestMethod.toLowerCase().equals("get")) {
            if (ContentType.FORM_URLENCODED.getValue().equals(contentType) || ContentType.MULTIPART.getValue().equals(contentType)) {
                return HttpRequest.get(url).addHeaders(headerMap).form(paramsMap).timeout(timeout).execute().body();
            } else {
                return HttpRequest.get(url).addHeaders(headerMap).body(JSON.toJSONString(paramsMap), contentType).timeout(timeout).execute().body();
            }
        } else if (requestMethod.toLowerCase().equals("put")) {
            if (ContentType.FORM_URLENCODED.getValue().equals(contentType) || ContentType.MULTIPART.getValue().equals(contentType)) {
                return HttpRequest.put(url).addHeaders(headerMap).form(paramsMap).timeout(timeout).execute().body();
            } else {
                return HttpRequest.put(url).addHeaders(headerMap).body(JSON.toJSONString(paramsMap), contentType).timeout(timeout).execute().body();
            }
        } else if (requestMethod.toLowerCase().equals("delete")) {
            if (ContentType.FORM_URLENCODED.getValue().equals(contentType) || ContentType.MULTIPART.getValue().equals(contentType)) {
                return HttpRequest.delete(url).addHeaders(headerMap).form(paramsMap).timeout(timeout).execute().body();
            } else {
                return HttpRequest.delete(url).addHeaders(headerMap).body(JSON.toJSONString(paramsMap), contentType).timeout(timeout).execute().body();
            }
        } else {
            if (ContentType.FORM_URLENCODED.getValue().equals(contentType) || ContentType.MULTIPART.getValue().equals(contentType)) {
                return HttpRequest.post(url).addHeaders(headerMap).form(paramsMap).timeout(timeout).execute().body();
            } else {
                return HttpRequest.post(url).addHeaders(headerMap).body(JSON.toJSONString(paramsMap), contentType).timeout(timeout).execute().body();
            }
        }
    }

    /**
     * http请求
     * @param url
     * @param body
     * @param headerMap
     * @param contentType
     * @param requestMethod
     * @return
     * @throws
     */
    public static String doHttp(String url, String body, Map headerMap, String contentType, String requestMethod, Integer timeout) throws BusinessException{
        if (ObjectUtils.isEmpty(timeout)) {
            //默认设置不超时
            timeout = -1;
        }
        if (requestMethod.toLowerCase().equals("get")) {
            return HttpRequest.get(url).addHeaders(headerMap).body(body, contentType).timeout(timeout).execute().body();
        } else if (requestMethod.toLowerCase().equals("put")) {
            return HttpRequest.put(url).addHeaders(headerMap).body(body, contentType).timeout(timeout).execute().body();
        } else if (requestMethod.toLowerCase().equals("delete")) {
            return HttpRequest.delete(url).addHeaders(headerMap).body(body, contentType).timeout(timeout).execute().body();
        } else {
            return HttpRequest.post(url).addHeaders(headerMap).body(body, contentType).timeout(timeout).execute().body();
        }
    }
}
