package com.wlos.app.utils;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.wlos.app.exception.BusinessException;
import com.wlos.app.model.BlocklyBindParamDto;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.openjdk.nashorn.api.scripting.ScriptObjectMirror;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @ClassName BlocklyUtils
 * js 运算工具类
 */
@Slf4j
public class BlocklyUtils {

    public static Object exe(String script, List<BlocklyBindParamDto> bindparams){
        if (StringUtils.isBlank(script)) {
            return null;
        }
        try {
            Map<String, Object> bindings = new HashMap<>();
            Map<String, Object> bindingsListMap = new HashMap<>();
            //执行脚本语言
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("nashorn");
            for (BlocklyBindParamDto bindparam : bindparams) {
                String bindKey = bindparam.getBindKey();
                Object bindValue = bindparam.getBindValue();
                String bindType = bindparam.getBindType();
                log.info("bindKey===" + bindKey + "=====bindValue====" + bindValue);
                /*//判断参数类型，如果是数组或者集合参数，则拼接到script中传入，非以上类型，则bingings类型传入
                if (null!=bindValue &&
                        (bindValue instanceof List
                                || bindValue.getClass().isArray()
                                || bindValue instanceof JSONObject
                                || bindValue instanceof JSONArray)) {
                    bindingsListMap.put(bindKey, bindValue);
                } else {
                    if (null == bindValue || "".equals(bindValue)) {
                        if (Constants.DM_DATA_TYPE_AMOUNT.equals(bindType)
                                || Constants.DM_DATA_TYPE_DECIMAL.equals(bindType)
                                || Constants.DM_DATA_TYPE_DOUBLE.equals(bindType)
                                || Constants.DM_DATA_TYPE_INTEGER.equals(bindType)
                        ) {
                            bindValue = BigDecimal.ZERO;
                        } else {
                            bindValue = "";
                        }
                    }
                    bindings.put(bindKey, bindValue);
                }*/
                    engine.put(bindKey, bindValue);
            }
            
            Object evalValue = null;
            try {
                evalValue = engine.eval(script);
            } catch (ScriptException e) {
                throw new RuntimeException(e);
            }
            log.info("=====blockly js执行输出的结果====" + JSON.toJSONString(evalValue));
            boolean isArray = false;
            //js执行返回的结果是ScriptObjectMirror类型
            if (evalValue instanceof ScriptObjectMirror) {
                ScriptObjectMirror som = (ScriptObjectMirror) evalValue;
                if (som.isArray()) {
                    isArray = true;
                }
            }
            if (isArray) {
                List<Object> list = new ArrayList<>();
                ScriptObjectMirror mirror = (ScriptObjectMirror) evalValue;
                for (Map.Entry<String, Object> entry : mirror.entrySet()) {
                    Object result = entry.getValue();
                    if (result instanceof ScriptObjectMirror) {
                        list.add(result);
                    } else {
                        list.add(result);
                    }
                }
                evalValue = list;
            }
            return evalValue;
        }catch (Exception e){
            e.printStackTrace();
            log.error("操作异常", "运算失败");
            throw new BusinessException("赋值blockly类型处理失败", e);
        }
    }
}

