package com.wlos.app.utils;

import cn.hutool.core.util.RandomUtil;
import org.apache.commons.lang3.ObjectUtils;

import java.util.List;
import java.util.stream.Collectors;

public class BlocklyTextUtils {

    /**
     * 获取对象长度
     * @param arg0 参数
     * @return 返回值
     */
    public static int getLength(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) {
            return 0;
        }
        if (arg0 instanceof String string) {
            return string.length();
        } else if (arg0 instanceof List list) {
            return list.size();
        } else if (arg0.getClass().isArray()) {
            return List.of(arg0).size();
        } else {
            return 0;
        }
    }

    public static String textCharAtFirstStart(Object arg0, Object arg1) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        String arg0Str = String.valueOf(arg0);
        if (ObjectUtils.isEmpty(arg1)) return arg0Str.substring(0, 1);
        return String.valueOf(arg0Str.charAt(Integer.parseInt(String.valueOf(arg1)) - 1));
    }

    public static String textCharAtFirstEnd(Object arg0, Object arg1) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        String arg0Str = String.valueOf(arg0);
        if (ObjectUtils.isEmpty(arg1)) return arg0Str.substring(arg0Str.length()-1);
        return String.valueOf(arg0Str.charAt(arg0Str.length() - Integer.parseInt(String.valueOf(arg1))));
    }

    public static String textCharAtFirst(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        String arg0Str = String.valueOf(arg0);
        return arg0Str.substring(0, 1);
    }

    public static String textCharAtLast(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        String arg0Str = String.valueOf(arg0);
        return arg0Str.substring(arg0Str.length()-1);
    }

    public static String textCharAtRandom(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        String arg0Str = String.valueOf(arg0);
        return String.valueOf(arg0Str.charAt(RandomUtil.randomInt(arg0Str.length())));
    }

    public static String textGetSubstring(Object arg0, String where1, Object at1, String where2, Object at2) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        String arg0Str = String.valueOf(arg0);
        int startAt = 0;
        int endAt = arg0Str.length()-1;
        if (where1.equals("FROM_END")) {
            if (ObjectUtils.isEmpty(at1)) {
                startAt = arg0Str.length() - 1;
            } else {
                startAt = arg0Str.length() - Integer.parseInt(String.valueOf(at1));
            }
        } else if (where1.equals("FROM_START")) {
            if (ObjectUtils.isNotEmpty(at1)) {
                startAt = Integer.parseInt(String.valueOf(at1)) - 1;
            }
        }

        if (where2.equals("FROM_END")) {
            if (ObjectUtils.isNotEmpty(at2)) {
                endAt = arg0Str.length() - Integer.parseInt(String.valueOf(at2));
            }
        } else if (where2.equals("FROM_START")) {
            if (ObjectUtils.isNotEmpty(at2)) {
                endAt = Integer.parseInt(String.valueOf(at2));
            }
        }
        return arg0Str.substring(startAt, endAt);
    }

    public static String textJoin(List arg0) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        return (String) arg0.stream().map(item -> ObjectUtils.isNotEmpty(item) ? String.valueOf(item) : "").collect(Collectors.joining());
    }

    public static String textReverse(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        String arg0Str = String.valueOf(arg0);
        return new StringBuffer(arg0Str).reverse().toString();
    }

    public static String textRemove(Object arg0, Object arg1) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        String arg0Str = String.valueOf(arg0);
        if (ObjectUtils.isEmpty(arg1)) return arg0Str;

        return arg0Str.replace(String.valueOf(arg1), "");
    }

    public static int textCountStr(Object arg0, Object arg1) {
        if (ObjectUtils.isEmpty(arg0) || ObjectUtils.isEmpty(arg1)) return 0;
        String arg0Str = String.valueOf(arg0);
        String arg1Str = String.valueOf(arg1);
        int count = 0;
        while (arg0Str.indexOf(arg1Str) != -1) {
            count++;
            arg0Str = arg0Str.substring(arg0Str.indexOf(arg1Str) + arg1Str.length());
        }
        return count;
    }

    public static String textReplace(Object arg0, Object arg1, Object arg2) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        String arg0Str = String.valueOf(arg0);
        if (ObjectUtils.isEmpty(arg1) || ObjectUtils.isEmpty(arg2)) return arg0Str;
        return arg0Str.replace(String.valueOf(arg1), String.valueOf(arg2));
    }
}
