package com.wlos.app.utils;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang3.ObjectUtils;

import java.util.*;
import java.util.stream.Collectors;

public class BlocklyListsUtils {

    public static List listsRepeat(Object arg0, Object arg1) {
        if (ObjectUtils.isEmpty(arg1)) return null;
        int count = Integer.parseInt(String.valueOf(arg1));
        if (count < 1) {
            return null;
        }
        List list = new ArrayList();
        for (int i = 0; i < count; i++) {
            list.add(arg0);
        }
        return list;
    }

    public static List listsReverse(Object arg0){
        if (ObjectUtils.isEmpty(arg0)) return null;
        List argList = new ArrayList();
        Collections.reverse(argList);
        return argList;
    }

    public static int listsIndexOf(Object arg0, Object arg1) {
        if (ObjectUtils.isEmpty(arg0) || ObjectUtils.isEmpty(arg1)) {
            return -1;
        }
        List argList = new ArrayList();
        for (int i = 0; i < argList.size(); i++) {
            if (Objects.equals(argList.get(i), arg1)) {
                return i;
            }
        }
        return -1;
    }

    public static int listsLastIndexOf(Object arg0, Object arg1) {
        if (ObjectUtils.isEmpty(arg0) || ObjectUtils.isEmpty(arg1)) {
            return -1;
        }
        List argList = new ArrayList();
        for (int i = argList.size() - 1; i < argList.size(); i--) {
            if (Objects.equals(argList.get(i), arg1)) {
                return i;
            }
        }
        return -1;
    }

    public static Object listsGetIndex(Object arg0, Object at, String mode, String where) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        List argList = new ArrayList();
        int startAt = 0;
        if (where.equals("FROM_END")) {
            if (ObjectUtils.isEmpty(at)) {
                startAt = argList.size() - 1;
            } else {
                startAt = argList.size() - Integer.parseInt(String.valueOf(at));
            }
        } else if (where.equals("FROM_START")) {
            if (ObjectUtils.isNotEmpty(at)) {
                startAt = Integer.parseInt(String.valueOf(at)) - 1;
            }
        } else if (where.equals("LAST")) {
            startAt = argList.size();
        } else if (where.equals("RANDOM")) {
            startAt = RandomUtil.randomInt(argList.size());
        }
        if (mode.equals("GET_REMOVE")) {
            Object getObj = argList.get(startAt);
            argList.remove(startAt);
            return getObj;
        } else if (mode.equals("REMOVE")) {
            argList.remove(startAt);
            return null;
        } else {
            return argList.get(startAt);
        }
    }

    public static Object listsSetIndex(Object arg0, Object at, String mode, String where, Object to) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        List argList = new ArrayList();
        int startAt = 0;
        if (where.equals("FROM_END")) {
            if (ObjectUtils.isEmpty(at)) {
                startAt = argList.size() - 1;
            } else {
                startAt = argList.size() - Integer.parseInt(String.valueOf(at));
            }
        } else if (where.equals("FROM_START")) {
            if (ObjectUtils.isNotEmpty(at)) {
                startAt = Integer.parseInt(String.valueOf(at)) - 1;
            }
        } else if (where.equals("LAST")) {
            startAt = argList.size();
        } else if (where.equals("RANDOM")) {
            startAt = RandomUtil.randomInt(argList.size());
        }
        if (mode.equals("SET")) {
            //设置
            argList.set(startAt, to);
        } else {
            //INSERT插入
            argList.add(startAt, to);
        }
        return argList;
    }

    public static List listsGetSublist(Object arg0, String where1, Object at1, String where2, Object at2) {
        if (ObjectUtils.isEmpty(arg0)) return null;
        List argList = new ArrayList();
        int startAt = 0;
        int endAt = argList.size()-1;
        if (where1.equals("FROM_END")) {
            if (ObjectUtils.isEmpty(at1)) {
                startAt = argList.size() - 1;
            } else {
                startAt = argList.size() - Integer.parseInt(String.valueOf(at1));
            }
        } else if (where1.equals("FROM_START")) {
            if (ObjectUtils.isNotEmpty(at1)) {
                startAt = Integer.parseInt(String.valueOf(at1)) - 1;
            }
        }

        if (where2.equals("FROM_END")) {
            if (ObjectUtils.isNotEmpty(at2)) {
                endAt = argList.size() - Integer.parseInt(String.valueOf(at2));
            }
        } else if (where2.equals("FROM_START")) {
            if (ObjectUtils.isNotEmpty(at2)) {
                endAt = Integer.parseInt(String.valueOf(at2));
            }
        }
        if (startAt < 0) {
            startAt = 0;
        }
        if (endAt >= argList.size()) {
            endAt = argList.size() - 1;
        }
        return argList.subList(startAt, endAt);
    }

    public static List listsSplit(Object arg0, Object arg1) {
        if (ObjectUtils.isEmpty(arg0)) {
            return null;
        }
        String arg0Str = String.valueOf(arg0);
        List list = new ArrayList();
        if (ObjectUtils.isNotEmpty(arg1)) {
            Collections.addAll(list, arg0Str.split(String.valueOf(arg1)));
        } else {
            Collections.addAll(list, arg0Str.split(""));
        }
        return list;
    }

    public static String listsJoin(Object arg0, Object arg1) {
        if (ObjectUtils.isEmpty(arg0)) {
            return null;
        }
        List argList = new ArrayList();
        if (ObjectUtils.isNotEmpty(arg1)) {
            return (String) argList.stream().map(item -> ObjectUtils.isNotEmpty(item) ? String.valueOf(item) : "").collect(Collectors.joining(String.valueOf(arg1)));
        } else {
            return (String) argList.stream().map(item -> ObjectUtils.isNotEmpty(item) ? String.valueOf(item) : "").collect(Collectors.joining(""));
        }
    }

    public static List listsSort(Object arg0, String type, String direction) {
        if (ObjectUtils.isEmpty(arg0)) {
            return null;
        }
        List list = new ArrayList();
        if (direction.equals("-1")) {
            //倒序
            list.sort(Comparator.comparing(item->String.valueOf(item)).reversed());
        } else {
            //正序
            list.sort(Comparator.comparing(item->String.valueOf(item)));
        }
        return list;
    }

    public static List listsRemoveNull(Object arg0) {
        if (ObjectUtils.isEmpty(arg0)) {
            return null;
        }
        List list = new ArrayList();
        list.remove(null);
        return list;
    }

    /**
     * 获取对象集合中某一属性的值的集合
     * @param arg0
     * @param key
     * @return
     */
    public static List listsGetListByKey(Object arg0, Object key) {
        if (ObjectUtils.isEmpty(arg0) || ObjectUtils.isEmpty(key)) {
            return null;
        }
        List list = new ArrayList();
        try {
            return list.stream().map(item -> JSON.parseObject(JSON.toJSONString(item)).get(String.valueOf(key))).toList();
        } catch (Exception e) {
            return null;
        }
    }
}
