package com.wlos.app.model.vo;

import com.wlos.app.enums.AnalysisEnums;
import com.google.common.collect.Lists;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 系列项
 */
public class SeriesItem {

    private String uuid;

    private String seriesName;

    private String type;

    /**
     * 颜色
     */
    private SeriesColumnItem color;
    /**
     * 标记
     */
    private SeriesColumnItem symbol;
    /**
     * 标记大小
     */
    private SeriesColumnItem symbolSize;
    /**
     * 标签
     */
    private SeriesColumnItem label;
    /**
     * 提示框
     */
    private SeriesColumnItem tooltip;
    /**
     * 大小
     */
    private SeriesColumnItem barWidth;
    /**
     * 角度
     */
    private SeriesColumnItem startAngle;
    /**
     * 半径
     */
    private SeriesColumnItem radius;
    /**
     * 线条颜色
     */
    private SeriesColumnItem lineStyleColor;
    /**
     * 区域颜色
     */
    private SeriesColumnItem areaStyleColor;
    /**
     * 线条大小
     */
    private SeriesColumnItem lineStyleWidth;
    /**
     * 排序
     */
    private List<String> orderFields;

    public List<AnalysisDataDTO> transformAnalysisDataModelList() {
        List<AnalysisDataDTO> list = Lists.newArrayList();
        if (CollectionUtils.isEmpty(this.getOrderFields())) return Lists.newArrayList();
        this.getOrderFields().stream().forEach(orderField -> {
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.COLOR.getTag()) && Objects.nonNull(this.getColor())) {
                list.addAll(this.getColor().getColumns());
            }
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.SYMBOL.getTag()) && Objects.nonNull(this.getSymbol())) {
                list.addAll(this.getSymbol().getColumns());
            }
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.SYMBOL_SIZE.getTag()) && Objects.nonNull(this.getSymbolSize())) {
                list.addAll(this.getSymbolSize().getColumns());
            }
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.LABEL.getTag()) && Objects.nonNull(this.getLabel())) {
                list.addAll(this.getLabel().getColumns());
            }
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.TOOLTIP.getTag()) && Objects.nonNull(this.getTooltip())) {
                list.addAll(this.getTooltip().getColumns());
            }
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.BAR_WIDTH.getTag()) && Objects.nonNull(this.getBarWidth())) {
                list.addAll(this.getBarWidth().getColumns());
            }
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.START_ANGLE.getTag()) && Objects.nonNull(this.getStartAngle())) {
                list.addAll(this.getStartAngle().getColumns());
            }
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.RADIUS.getTag()) && Objects.nonNull(this.getRadius())) {
                list.addAll(this.getRadius().getColumns());
            }
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.LINE_STYLE_COLOR.getTag()) && Objects.nonNull(this.getLineStyleColor())) {
                list.addAll(this.getLineStyleColor().getColumns());
            }
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.AREA_STYLE_COLOR.getTag()) && Objects.nonNull(this.getAreaStyleColor())) {
                list.addAll(this.getAreaStyleColor().getColumns());
            }
            if (Objects.equals(orderField, AnalysisEnums.SeriesItemTag.LINE_STYLE_WIDTH.getTag()) && Objects.nonNull(this.getLineStyleWidth())) {
                list.addAll(this.getLineStyleWidth().getColumns());
            }
        });
        return list;
    }

    public SeriesColumnItem getColor() {
        return color;
    }

    public void setColor(SeriesColumnItem color) {
        this.color = color;
    }

    public SeriesColumnItem getSymbol() {
        return symbol;
    }

    public void setSymbol(SeriesColumnItem symbol) {
        this.symbol = symbol;
    }

    public SeriesColumnItem getSymbolSize() {
        return symbolSize;
    }

    public void setSymbolSize(SeriesColumnItem symbolSize) {
        this.symbolSize = symbolSize;
    }

    public SeriesColumnItem getLabel() {
        return label;
    }

    public void setLabel(SeriesColumnItem label) {
        this.label = label;
    }

    public SeriesColumnItem getTooltip() {
        return tooltip;
    }

    public void setTooltip(SeriesColumnItem tooltip) {
        this.tooltip = tooltip;
    }

    public List<String> getOrderFields() {
        return orderFields;
    }

    public void setOrderFields(List<String> orderFields) {
        this.orderFields = orderFields;
    }

    public String getUuid() {
        return uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public String getSeriesName() {
        return seriesName;
    }

    public void setSeriesName(String seriesName) {
        this.seriesName = seriesName;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SeriesColumnItem getBarWidth() {
        return barWidth;
    }

    public void setBarWidth(SeriesColumnItem barWidth) {
        this.barWidth = barWidth;
    }

    public SeriesColumnItem getStartAngle() {
        return startAngle;
    }

    public void setStartAngle(SeriesColumnItem startAngle) {
        this.startAngle = startAngle;
    }

    public SeriesColumnItem getRadius() {
        return radius;
    }

    public void setRadius(SeriesColumnItem radius) {
        this.radius = radius;
    }

    public SeriesColumnItem getLineStyleColor() {
        return lineStyleColor;
    }

    public void setLineStyleColor(SeriesColumnItem lineStyleColor) {
        this.lineStyleColor = lineStyleColor;
    }

    public SeriesColumnItem getAreaStyleColor() {
        return areaStyleColor;
    }

    public void setAreaStyleColor(SeriesColumnItem areaStyleColor) {
        this.areaStyleColor = areaStyleColor;
    }

    public SeriesColumnItem getLineStyleWidth() {
        return lineStyleWidth;
    }

    public void setLineStyleWidth(SeriesColumnItem lineStyleWidth) {
        this.lineStyleWidth = lineStyleWidth;
    }
}
