package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 场馆信息 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:35 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "venue_information")
public class VenueInformation implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 字段_id
     */
    @TableId(value = "id",type = IdType.AUTO)
    private String id;

    /**
     * 创建时间
     */
    @TableField(value = "creation_time")
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    @TableField(value = "modification_time")
    private LocalDateTime modificationTime;

    /**
     * 场馆名称
     */
    @TableField(value = "venue_name")
    private String venueName;

    /**
     * 所属省代码
     */
    @TableField(value = "province")
    private String province;

    /**
     * 所属市代码
     */
    @TableField(value = "city")
    private String city;

    /**
     * 联系电话
     */
    @TableField(value = "phone")
    private String phone;

    /**
     * 场馆地址
     */
    @TableField(value = "venue_address")
    private String venueAddress;

    /**
     * 场地类型
     */
    @TableField(value = "venue_type")
    private String venueType;

    /**
     * 来源 （0代表共享，1代表私有）
     */
    @TableField(value = "nature")
    private String nature;

    /**
     * 创建者id
     */
    @TableField(value = "user_id")
    private Long userId;

    /**
     * 上级场地id
     */
    @TableField(value = "parent_id")
    private Long parentId;

    /**
     * 场馆介绍
     */
    @TableField(value = "venue_introduction")
    private String venueIntroduction;

    /**
     * 区域位置
     */
    @TableField(value = "regional_location")
    private String regionalLocation;

    /**
     * 营业执照地址
     */
    @TableField(value = "business_license_addr")
    private String businessLicenseAddr;

    /**
     * 统一信用代码
     */
    @TableField(value = "unified_credit_code")
    private String unifiedCreditCode;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setModificationTime(LocalDateTime modificationTime) {
        this.modificationTime = modificationTime;
    }

    public LocalDateTime getModificationTime() {
        return modificationTime;
    }

    public void setVenueName(String venueName) {
        this.venueName = venueName;
    }

    public String getVenueName() {
        return venueName;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getProvince() {
        return province;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCity() {
        return city;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPhone() {
        return phone;
    }

    public void setVenueAddress(String venueAddress) {
        this.venueAddress = venueAddress;
    }

    public String getVenueAddress() {
        return venueAddress;
    }

    public void setVenueType(String venueType) {
        this.venueType = venueType;
    }

    public String getVenueType() {
        return venueType;
    }

    public void setNature(String nature) {
        this.nature = nature;
    }

    public String getNature() {
        return nature;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setParentId(Long parentId) {
        this.parentId = parentId;
    }

    public Long getParentId() {
        return parentId;
    }

    public void setVenueIntroduction(String venueIntroduction) {
        this.venueIntroduction = venueIntroduction;
    }

    public String getVenueIntroduction() {
        return venueIntroduction;
    }

    public void setRegionalLocation(String regionalLocation) {
        this.regionalLocation = regionalLocation;
    }

    public String getRegionalLocation() {
        return regionalLocation;
    }

    public void setBusinessLicenseAddr(String businessLicenseAddr) {
        this.businessLicenseAddr = businessLicenseAddr;
    }

    public String getBusinessLicenseAddr() {
        return businessLicenseAddr;
    }

    public void setUnifiedCreditCode(String unifiedCreditCode) {
        this.unifiedCreditCode = unifiedCreditCode;
    }

    public String getUnifiedCreditCode() {
        return unifiedCreditCode;
    }



}