package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 任务信息 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:34 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "survey_task")
public class SurveyTask implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @TableId(value = "id")
    private String id;

    /**
     * 创建时间
     */
    @TableField(value = "creation_time")
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    @TableField(value = "modification_time")
    private LocalDateTime modificationTime;

    /**
     * 任务名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 活动ID
     */
    @TableField(value = "activity_id")
    private Long activityId;

    /**
     * 活动开始时间
     */
    @TableField(value = "star_time")
    private LocalDateTime starTime;

    /**
     * 活动结束时间
     */
    @TableField(value = "end_time")
    private LocalDateTime endTime;

    /**
     * 活动地址
     */
    @TableField(value = "address")
    private String address;

    /**
     * 联系人
     */
    @TableField(value = "contacts")
    private String contacts;

    /**
     * 联系电话
     */
    @TableField(value = "contact_mobile")
    private String contactMobile;

    /**
     * 状态（0:未接受;1:进行中;2:已办结;2:已办结;3:退回;9:已超时;）
     */
    @TableField(value = "survey_task_status")
    private String surveyTaskStatus;

    /**
     * 接受时间
     */
    @TableField(value = "accept_time")
    private LocalDateTime acceptTime;

    /**
     * 完成时间
     */
    @TableField(value = "finish_time")
    private LocalDateTime finishTime;

    /**
     * 踏勘人员ID
     */
    @TableField(value = "user_id")
    private Long userId;

    /**
     * 场馆ID
     */
    @TableField(value = "venue_id")
    private Long venueId;

    /**
     * 主站任务ID
     */
    @TableField(value = "task_id")
    private Long taskId;

    /**
     * 地址类型
     */
    @TableField(value = "address_type")
    private String address_type;

    /**
     * 活动类型
     */
    @TableField(value = "activity_type")
    private String activity_type;

    /**
     * 市编码
     */
    @TableField(value = "city")
    private String city;

    /**
     * 省编码
     */
    @TableField(value = "province")
    private String province;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setModificationTime(LocalDateTime modificationTime) {
        this.modificationTime = modificationTime;
    }

    public LocalDateTime getModificationTime() {
        return modificationTime;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setStarTime(LocalDateTime starTime) {
        this.starTime = starTime;
    }

    public LocalDateTime getStarTime() {
        return starTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getAddress() {
        return address;
    }

    public void setContacts(String contacts) {
        this.contacts = contacts;
    }

    public String getContacts() {
        return contacts;
    }

    public void setContactMobile(String contactMobile) {
        this.contactMobile = contactMobile;
    }

    public String getContactMobile() {
        return contactMobile;
    }

    public void setSurveyTaskStatus(String surveyTaskStatus) {
        this.surveyTaskStatus = surveyTaskStatus;
    }

    public String getSurveyTaskStatus() {
        return surveyTaskStatus;
    }

    public void setAcceptTime(LocalDateTime acceptTime) {
        this.acceptTime = acceptTime;
    }

    public LocalDateTime getAcceptTime() {
        return acceptTime;
    }

    public void setFinishTime(LocalDateTime finishTime) {
        this.finishTime = finishTime;
    }

    public LocalDateTime getFinishTime() {
        return finishTime;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setVenueId(Long venueId) {
        this.venueId = venueId;
    }

    public Long getVenueId() {
        return venueId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setAddress_type(String address_type) {
        this.address_type = address_type;
    }

    public String getAddress_type() {
        return address_type;
    }

    public void setActivity_type(String activity_type) {
        this.activity_type = activity_type;
    }

    public String getActivity_type() {
        return activity_type;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getCity() {
        return city;
    }

    public void setProvince(String province) {
        this.province = province;
    }

    public String getProvince() {
        return province;
    }



}