package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 问卷 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:27 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "survey_questionnaire")
public class SurveyQuestionnaire implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.AUTO)
    private String id;

    /**
     * 创建时间
     */
    @TableField(value = "creation_time")
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    @TableField(value = "modification_time")
    private LocalDateTime modificationTime;

    /**
     * 踏勘开始时间
     */
    @TableField(value = "begin_time")
    private LocalDateTime beginTime;

    /**
     * 是否整改
     */
    @TableField(value = "correction")
    private Boolean correction;

    /**
     * 踏勘结束时间
     */
    @TableField(value = "end_time")
    private LocalDateTime endTime;

    /**
     * 是否生成问卷
     */
    @TableField(value = "generate")
    private Boolean generate;

    /**
     * 踏勘报告路径
     */
    @TableField(value = "report_path")
    private String reportPath;

    /**
     * 踏勘阶段
     */
    @TableField(value = "survey_step")
    private String surveyStep;

    /**
     * 踏勘状态
     */
    @TableField(value = "task_status")
    private String taskStatus;

    /**
     * 所属活动踏勘阶段ID
     */
    @TableField(value = "feedback_id")
    private Long feedbackId;

    /**
     * 场地ID
     */
    @TableField(value = "venue_id")
    private Long venueId;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setModificationTime(LocalDateTime modificationTime) {
        this.modificationTime = modificationTime;
    }

    public LocalDateTime getModificationTime() {
        return modificationTime;
    }

    public void setBeginTime(LocalDateTime beginTime) {
        this.beginTime = beginTime;
    }

    public LocalDateTime getBeginTime() {
        return beginTime;
    }

    public void setCorrection(Boolean correction) {
        this.correction = correction;
    }

    public Boolean getCorrection() {
        return correction;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setGenerate(Boolean generate) {
        this.generate = generate;
    }

    public Boolean getGenerate() {
        return generate;
    }

    public void setReportPath(String reportPath) {
        this.reportPath = reportPath;
    }

    public String getReportPath() {
        return reportPath;
    }

    public void setSurveyStep(String surveyStep) {
        this.surveyStep = surveyStep;
    }

    public String getSurveyStep() {
        return surveyStep;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getTaskStatus() {
        return taskStatus;
    }

    public void setFeedbackId(Long feedbackId) {
        this.feedbackId = feedbackId;
    }

    public Long getFeedbackId() {
        return feedbackId;
    }

    public void setVenueId(Long venueId) {
        this.venueId = venueId;
    }

    public Long getVenueId() {
        return venueId;
    }



}