package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 勘查计划 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:28 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "survey_plan")
public class SurveyPlan implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.AUTO)
    private String id;

    /**
     * 创建时间
     */
    @TableField(value = "creation_time")
    private LocalDateTime creationTime;

    /**
     * 修改时间
     */
    @TableField(value = "modification_time")
    private LocalDateTime modificationTime;

    /**
     * 总共天数
     */
    @TableField(value = "all_day")
    private Boolean allDay;

    /**
     * 踏勘开始时间
     */
    @TableField(value = "begin_time")
    private LocalDateTime beginTime;

    /**
     * 踏勘结束时间
     */
    @TableField(value = "end_time")
    private LocalDateTime endTime;

    /**
     * 承办方负责人签字
     */
    @TableField(value = "purveyor_sign_path")
    private String purveyorSignPath;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 客户经理签字
     */
    @TableField(value = "sign_img_path")
    private String signImgPath;

    /**
     * 踏勘阶段
     */
    @TableField(value = "survey_step")
    private String surveyStep;

    /**
     * 踏勘状态
     */
    @TableField(value = "task_status")
    private String taskStatus;

    /**
     * 踏勘次数
     */
    @TableField(value = "time")
    private Integer time;

    /**
     * 对应踏勘阶段
     */
    @TableField(value = "feedback_id")
    private Long feedbackId;

    /**
     * 对应踏勘场地问题
     */
    @TableField(value = "questionnaire_id")
    private Long questionnaireId;

    /**
     * 踏勘任务ID
     */
    @TableField(value = "task_id")
    private Long taskId;

    /**
     * 用户ID
     */
    @TableField(value = "user_id")
    private Long userId;

    /**
     * 场地ID
     */
    @TableField(value = "venue_id")
    private Long venueId;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setCreationTime(LocalDateTime creationTime) {
        this.creationTime = creationTime;
    }

    public LocalDateTime getCreationTime() {
        return creationTime;
    }

    public void setModificationTime(LocalDateTime modificationTime) {
        this.modificationTime = modificationTime;
    }

    public LocalDateTime getModificationTime() {
        return modificationTime;
    }

    public void setAllDay(Boolean allDay) {
        this.allDay = allDay;
    }

    public Boolean getAllDay() {
        return allDay;
    }

    public void setBeginTime(LocalDateTime beginTime) {
        this.beginTime = beginTime;
    }

    public LocalDateTime getBeginTime() {
        return beginTime;
    }

    public void setEndTime(LocalDateTime endTime) {
        this.endTime = endTime;
    }

    public LocalDateTime getEndTime() {
        return endTime;
    }

    public void setPurveyorSignPath(String purveyorSignPath) {
        this.purveyorSignPath = purveyorSignPath;
    }

    public String getPurveyorSignPath() {
        return purveyorSignPath;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getRemark() {
        return remark;
    }

    public void setSignImgPath(String signImgPath) {
        this.signImgPath = signImgPath;
    }

    public String getSignImgPath() {
        return signImgPath;
    }

    public void setSurveyStep(String surveyStep) {
        this.surveyStep = surveyStep;
    }

    public String getSurveyStep() {
        return surveyStep;
    }

    public void setTaskStatus(String taskStatus) {
        this.taskStatus = taskStatus;
    }

    public String getTaskStatus() {
        return taskStatus;
    }

    public void setTime(Integer time) {
        this.time = time;
    }

    public Integer getTime() {
        return time;
    }

    public void setFeedbackId(Long feedbackId) {
        this.feedbackId = feedbackId;
    }

    public Long getFeedbackId() {
        return feedbackId;
    }

    public void setQuestionnaireId(Long questionnaireId) {
        this.questionnaireId = questionnaireId;
    }

    public Long getQuestionnaireId() {
        return questionnaireId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getTaskId() {
        return taskId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setVenueId(Long venueId) {
        this.venueId = venueId;
    }

    public Long getVenueId() {
        return venueId;
    }



}