package com.wlos.app.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.*;
import com.wlos.app.dto.CommonFileDTO;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.annotation.TableField;
import java.time.*;

/**
 * 查勘现场具体问题及反馈详情 实体类
 *
 * @author jiangnan
 * @date Aug 30, 2024, 5:03:26 PM
 * @since v0.1
 */
@TableName(resultMap = "BaseResultMap",value = "survey_info")
public class SurveyInfo implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 主键id
     */
    @TableId(value = "id",type = IdType.AUTO)
    private String id;

    /**
     * 踏勘结果
     */
    @TableField(value = "answer")
    private String answer;

    /**
     * 关联上次踏勘ID
     */
    @TableField(value = "last_survey_info_id")
    private String lastSurveyInfoId;

    /**
     * 是否下次踏勘
     */
    @TableField(value = "next_survey")
    private Integer nextSurvey;

    /**
     * 该问题是否已回答
     */
    @TableField(value = "replied")
    private Integer replied;

    /**
     * 活动场馆阶段问卷ID
     */
    @TableField(value = "questionnaire_id")
    private Long questionnaireId;

    /**
     * 整改意见ID
     */
    @TableField(value = "reform_id")
    private Long reformId;

    /**
     * 附件信息
     */
    @TableField(value = "urls")
    private String urls;




    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public void setAnswer(String answer) {
        this.answer = answer;
    }

    public String getAnswer() {
        return answer;
    }

    public void setLastSurveyInfoId(String lastSurveyInfoId) {
        this.lastSurveyInfoId = lastSurveyInfoId;
    }

    public String getLastSurveyInfoId() {
        return lastSurveyInfoId;
    }

    public void setNextSurvey(Integer nextSurvey) {
        this.nextSurvey = nextSurvey;
    }

    public Integer getNextSurvey() {
        return nextSurvey;
    }

    public void setReplied(Integer replied) {
        this.replied = replied;
    }

    public Integer getReplied() {
        return replied;
    }

    public void setQuestionnaireId(Long questionnaireId) {
        this.questionnaireId = questionnaireId;
    }

    public Long getQuestionnaireId() {
        return questionnaireId;
    }

    public void setReformId(Long reformId) {
        this.reformId = reformId;
    }

    public Long getReformId() {
        return reformId;
    }

    public void setUrls(String urls) {
        this.urls = urls;
    }

    public String getUrls() {
        return urls;
    }



}